extend("fiskheroes:hero_basic");
loadTextures({
	"layer1": "eden:iceman_layer1",
	"layer2": "eden:iceman_layer2",
	"icicle": "fiskheroes:killer_frost_icicle",
    "ice": "eden:iceman_ice",
    "wall": "eden:ice_wall",
    "frost": "eden:iceman_overlay",
});

var utils = implement("fiskheroes:external/utils");

var spikeL;

var spikeR;

var overlay;

var ice_wall;

var ice;

var ice_skate;

function init(renderer) {
    parent.init(renderer);

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    overlay = renderer.createEffect("fiskheroes:overlay");
    overlay.texture.set("ice");

    ice = renderer.createEffect("fiskheroes:overlay");
    ice.texture.set("frost");
	
	spikeL = renderer.createEffect("fiskheroes:shield");
    spikeL.texture.set("icicle");
    spikeL.anchor.set("rightArm");
    spikeL.setRotation(0.0, 0.0, -3.125).setCurve(20.0, 90.0);
    spikeR = renderer.createEffect("fiskheroes:shield");
    spikeR.texture.set("icicle");
    spikeR.anchor.set("rightArm");
    spikeR.setRotation(0.0, 180.0, -3.125).setCurve(20.0, 90.0);

    ice_wall = renderer.createEffect("fiskheroes:model");
    ice_wall.setModel(utils.createModel(renderer, "eden:ice_wall", "wall", null));
    ice_wall.anchor.ignoreAnchor(true);
    ice_wall.setScale(1.3);

    ice_skate = renderer.createEffect("fiskheroes:model");
    ice_skate.setModel(utils.createModel(renderer, "eden:ice_skate", "wall", null));
    ice_skate.anchor.ignoreAnchor(true);
    ice_skate.setScale(0.8);
	
    utils.bindParticles(renderer, "eden:iceman_trail").setCondition(entity => entity.getData("fiskheroes:flying"));

    utils.bindParticles(renderer, "fiskheroes:killer_frost_ice").setCondition(entity => entity.getData("fiskheroes:shield"));

    utils.bindParticles(renderer, "fiskheroes:killer_frost_ice").setCondition(entity => entity.getData("fiskheroes:blade"));

    utils.bindParticles(renderer, "fiskheroes:killer_frost_ice").setCondition(entity => entity.getData("fiskheroes:beam_charging") && entity.getData("fiskheroes:beam_charge") < 1);

    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:cold_beam", "body", 0x87cefa, [
        { "firstPerson": [-3.75, 3.0, -8.0], "offset": [0.5, 12.0, 0.0], "size": [3.0, 3.0], "anchor": "rightArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "eden:impact_ice"));
}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.AIMING");
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimation(renderer, "basic.AIMING", "fiskheroes:aiming").setData((entity, data) => {
        var charge = entity.getInterpolatedData("fiskheroes:beam_charge");
        data.load(Math.max(entity.getInterpolatedData("fiskheroes:aiming_timer"), entity.getData("fiskheroes:beam_charging") ? Math.min(charge * 3, 1) : Math.max(charge * 5 - 4, 0)));
    });

    renderer.removeCustomAnimation("basic.BLOCKING");
    addAnimationWithData(renderer, "basic.BLOCKING", "fiskheroes:dual_aiming", "fiskheroes:shield_blocking_timer")
    .priority = -5;
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {       

        spikeL.unfold = spikeR.unfold = entity.getInterpolatedData("fiskheroes:blade_timer");

        var f = Math.min(spikeL.unfold * 5, 1);
        spikeL.setOffset(2.25 + 1.0 * f, 8.0 + 2.0 * f, 0.0);
        spikeR.setOffset(-0.25 - 1.0 * f, 8.0 + 2.0 * f, 0.0);
        spikeL.render();
        spikeR.render();

        
    }
    if (renderLayer == "HELMET" || renderLayer == "CHESTPLATE") {
        overlay.opacity = entity.getInterpolatedData("fiskheroes:dyn/steel_timer");
        overlay.render();
    }
    if (renderLayer == "CHESTPLATE") {
        ice_wall.opacity = entity.getData("fiskheroes:shield_blocking_timer");
        ice_wall.render();
    
        var blade_anchor = ice_wall.anchor.ignoreAnchor(true);
        var blade_offSet = ice_wall.setOffset(2.0, -2, -10);
        var blade_rot = ice_wall.setRotation(-90, 90, 90);
        ice_wall.anchor = blade_anchor, blade_offSet, blade_rot;

    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        ice.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        ice.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        ice.opacity = entity.getInterpolatedData("fiskheroes:blade_timer");
        ice.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        ice.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer");
        ice.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        ice.opacity = entity.getInterpolatedData("flight_timer");
        ice.render();
    }
    if (renderLayer == "CHESTPLATE") {
        ice_skate.opacity = entity.getData("flight_timer");
        ice_skate.render();
    
        var blade_anchor = ice_skate.anchor.ignoreAnchor(true);
        var blade_offSet = ice_skate.setOffset(1.0, 22.0, 1.0);
        var blade_rot = ice_skate.setRotation(0, 0, 0);
        ice_skate.anchor = blade_anchor, blade_offSet, blade_rot;
    }
}