extend("fiskheroes:hero_basic");
loadTextures({
    "sword": "eden:dragon_sword",
    "layer1": "eden:jaakuna_layer1",
    "layer2": "eden:jaakuna_layer2",
    "jaakuna_magic": "eden:jaakuna_magic",

    "intangibility": "eden:thermal_form"
});

var utils = implement("fiskheroes:external/utils");

var shield;

var jaakuna_magic;

function init(renderer) {
    parent.init(renderer);
	
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    utils.addLivery(renderer, "CHOKUTO", "sword");

    intangibility = renderer.createEffect("fiskheroes:overlay");
    intangibility.texture.set(null, "intangibility");

    utils.setOpacityWithData(renderer, 0.9, 1.0, "fiskheroes:intangibility_timer");

    jaakuna_magic = renderer.createEffect("fiskheroes:overlay");
    jaakuna_magic.texture.set(null, "jaakuna_magic");

    var forcefield = renderer.bindProperty("fiskheroes:forcefield");
    forcefield.color.set(0xFF55FF);
    forcefield.setShape(36, 18).setOffset(0.0, 6.0, 0.0).setScale(1.25);
    forcefield.setCondition(entity => {
        forcefield.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer") * 0.15;
        return true;
    });

    var chain = utils.bindCloud(renderer, "fiskheroes:telekinesis_chain", "fiskheroes:shadow_smoke");
    chain.anchor.set("rightArm");
    chain.setOffset(-0.5, 10.0, 0.0);
    chain.setFirstPerson(-4.75, 4.0, -8.5);

    utils.bindParticles(renderer, "fiskheroes:black_manta_dceu_eyes").setCondition(entity => entity.getData("fiskheroes:energy_projection"));
    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:energy_projection", "head", 0xFF8000, [
        { "firstPerson": [0.0, 4.0, 0.0], "offset": [0.0, -1.4, 0.0], "size": [2.0, 2.0] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_energy_projection"));
    
    utils.bindParticles(renderer, "fiskheroes:black_manta_dceu_eyes").setCondition(entity => entity.getData("fiskheroes:beam_charging") && entity.getData("fiskheroes:beam_charge") < 1);
    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:energy_projection", "head", 0xFF8000, [
        { "firstPerson": [0.0, 4.0, 0.0], "offset": [0.0, -1.4, 0.0], "size": [2.0, 2.0] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

    utils.addCameraShake(renderer, 0.015, 1.5, "fiskheroes:flight_boost_timer");
    utils.bindParticles(renderer, "fiskheroes:firestorm").setCondition(entity => entity.getData("fiskheroes:flying"));
}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    utils.addFlightAnimation(renderer, "firestorm.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "firestorm.HOVER", "fiskheroes:flight/idle/propelled_hands");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE" || renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET") {
        intangibility.opacity = entity.getInterpolatedData("fiskheroes:intangibility_timer");
        intangibility.render();
    } 
    if (renderLayer == "HELMET") {
        jaakuna_magic.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        jaakuna_magic.render();
    }
}