extend("fiskheroes:hero_basic");
loadTextures({
    "sword": "eden:dragon_sword",
    "layer1": "eden:kai_long_human",
    "layer2": "eden:kai_long_human",
    "dragon": "eden:kai_long_layer1",
    "cape": "eden:kai_long_cape.tx.json",
    "kai_long_magic": "eden:kai_long_magic",

    "intangibility": "eden:thermal_form"
});

var utils = implement("fiskheroes:external/utils");
var capes = implement("fiskheroes:external/capes");

var shield;

var cape;

var kai_long_magic;

var overlay;

function initEffects(renderer) {
    utils.addLivery(renderer, "CHOKUTO", "sword");

    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.weight = 1.3;
    physics.maxFlare = 0.6;
    physics.flareDegree = 1.5;
    physics.flareFactor = 1.2;
    physics.flareElasticity = 5;
    cape = capes.createDefault(renderer, 24, "fiskheroes:cape_default.mesh.json", physics);
    cape.effect.texture.set("cape");
    cape.effect.width = 16;

    intangibility = renderer.createEffect("fiskheroes:overlay");
    intangibility.texture.set(null, "intangibility");

    overlay = renderer.createEffect("fiskheroes:overlay");
    overlay.texture.set("dragon");

    utils.setOpacityWithData(renderer, 0.9, 1.0, "fiskheroes:intangibility_timer");

    kai_long_magic = renderer.createEffect("fiskheroes:overlay");
    kai_long_magic.texture.set(null, "kai_long_magic");

    var forcefield = renderer.bindProperty("fiskheroes:forcefield");
    forcefield.color.set(0xFF8000);
    forcefield.setShape(36, 18).setOffset(0.0, 6.0, 0.0).setScale(1.25);
    forcefield.setCondition(entity => {
        forcefield.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer") * 0.15;
        return true;
    });

    utils.bindParticles(renderer, "fiskheroes:black_manta_dceu_eyes").setCondition(entity => entity.getData("fiskheroes:energy_projection"));
    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:energy_projection", "head", 0xFF8000, [
        { "firstPerson": [0.0, 4.0, 0.0], "offset": [0.0, -1.4, 0.0], "size": [2.0, 2.0] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_energy_projection"));
    
    utils.bindParticles(renderer, "fiskheroes:black_manta_dceu_eyes").setCondition(entity => entity.getData("fiskheroes:beam_charging") && entity.getData("fiskheroes:beam_charge") < 1);
    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:energy_projection", "head", 0xFF8000, [
        { "firstPerson": [0.0, 4.0, 0.0], "offset": [0.0, -1.4, 0.0], "size": [2.0, 2.0] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

    utils.addCameraShake(renderer, 0.015, 1.5, "fiskheroes:flight_boost_timer");
    utils.bindParticles(renderer, "fiskheroes:firestorm").setCondition(entity => entity.getData("fiskheroes:flying"));
}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    utils.addFlightAnimation(renderer, "firestorm.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "firestorm.HOVER", "fiskheroes:flight/idle/propelled_hands");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        overlay.opacity = entity.getInterpolatedData("fiskheroes:dyn/steel_timer");
        overlay.render();

        cape.render(entity);
    }
    if (renderLayer == "CHESTPLATE" || renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET") {
        intangibility.opacity = entity.getInterpolatedData("fiskheroes:intangibility_timer");
        intangibility.render();
    } 
    if (renderLayer == "HELMET") {
        kai_long_magic.opacity = entity.getInterpolatedData("fiskheroes:energy_projection_timer");
        kai_long_magic.render();
    }
    if (renderLayer == "HELMET") {
        kai_long_magic.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        kai_long_magic.render();
    }
}