extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:leviathan_layer1",
    "layer2": "eden:leviathan_layer2",
    "torrenite_energy": "eden:torrenite_energy",
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var torrenite_energy;


function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.setLights((entity, renderLayer) => {
        if (renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || renderLayer == "CHESTPLATE")

        return entity.getData("fiskheroes:speeding") ? "torrenite_energy" : "lights";
    });
}

function initEffects(renderer) {

    torrenite_energy = renderer.createEffect("fiskheroes:overlay");
    torrenite_energy.texture.set(null, "torrenite_energy");

    speedster.init(renderer, "eden:leviathan");

    // Antimatter Beam
    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:energy_projection", "body", 0x8beaf6, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_energy_projection"));

    // Antimatter Blast
    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:energy_projection", "rightArm", 0x8beaf6, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
        { "firstPerson": [4.5, 3.75, -8.0], "offset": [0.5, 9.0, 0.0], "size": [3.0, 3.0], "anchor": "leftArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

    utils.bindBeam(renderer, "fiskheroes:lightning_cast", "fiskheroes:energy_discharge", "rightArm", 0x8beaf6, [
        { "firstPerson": [-8.0, 4.5, -10.0], "offset": [-0.5, 9.0, 0.0], "size": [0.75, 0.75] }
    ]);	
}
function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");
    
	addAnimationWithData(renderer, "basic.AIMING", "fiskheroes:dual_aiming", "fiskheroes:beam_charge");
    utils.addFlightAnimation(renderer, "basic.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "basic.HOVER", "fiskheroes:flight/idle/propelled_hands");

    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        torrenite_energy.opacity = entity.getInterpolatedData("fiskheroes:energy_projection_timer");
        torrenite_energy.render();
    }
    if (renderLayer == "CHESTPLATE") {
        torrenite_energy.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        torrenite_energy.render();
    }
}