extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:lun_ra_layer1",
    "layer2": "eden:lun_ra_layer2",
    "shield": "eden:sheek_shield",
    "sword": "eden:sheek_sword",
});

var utils = implement("fiskheroes:external/utils");

function init(renderer) {
    parent.init(renderer);
	
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    utils.addLivery(renderer, "CHOKUTO", "sword");

    shield = renderer.createEffect("fiskheroes:shield");
    shield.texture.set("shield");
    shield.anchor.set("rightArm");
    shield.setCurve(25.0, 35.0);

    renderer.bindProperty("fiskheroes:energy_bolt").color.set(0xFF5555);
    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "body", "scale": 0.7, "offset": [-3.5, 2.0, 3.0], "rotation": [0.0, -90.0, 60.0] }
    ]).addOffset("QUIVER", 0.0, 0.0, 3.0);

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");


    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");

}
function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        shield.unfold = entity.getInterpolatedData("fiskheroes:shield_timer");
        shield.setOffset(2.9 + 1.35 * Math.min(shield.unfold * 5, 1), 5.0, 0.0);
        shield.render();
    }
}