extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:martian_x_layer1",
    "layer2": "eden:martian_x_layer2",
    "jetpack": "eden:martian_jetpack",
    "jetpack_lights": "eden:martian_jetpack_lights.tx.json",
    "blade": "eden:martian_blade",
    "lights": "eden:martian_lights",
    "metal": "eden:martian_helmet"
});

var utils = implement("fiskheroes:external/utils");
var mantapack = implement("fiskheroes:external/mantapack");

var jetpack;

var overlay;
var metal_heat;

var blade;
var booster_boots;

function init(renderer) {
    parent.init(renderer);
    renderer.setLights((entity, renderLayer) => renderLayer == "LEGGINGS" ? null : "lights");

        
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    blade = renderer.createEffect("fiskheroes:shield");
    blade.texture.set("blade");
    blade.anchor.set("rightArm");

    overlay = renderer.createEffect("fiskheroes:overlay");
    overlay.texture.set("metal");

    metal_heat = renderer.createEffect("fiskheroes:metal_heat");
    metal_heat.texture.set("metal");

    var red_fire = renderer.createResource("ICON", "fiskheroes:red_fire_layer_%s");
    booster_boots = renderer.createEffect("fiskheroes:booster");
    booster_boots.setIcon(red_fire).setOffset(0.0, 8.5, 2.0).setSize(1.5, 4.0);
    booster_boots.anchor.set("rightLeg");
    booster_boots.mirror = true;
    booster_boots.opacity = 0.7;
    jetpack = mantapack.create(renderer, "jetpack", "jetpack_lights", red_fire);

    utils.bindBeam(renderer, "fiskheroes:energy_manipulation", "fiskheroes:energy_discharge", "rightArm", 0x55FF55, [
        { "firstPerson": [-2.5, 0.0, -7.0], "offset": [-0.5, 19.0, -12.0], "size": [1.5, 1.5] }
    ]);

    renderer.bindProperty("fiskheroes:energy_bolt").color.set(0x55FF55);
    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "body", "scale": 0.7, "offset": [-3.5, 2.0, 3.0], "rotation": [0.0, -90.0, 60.0] }
    ]).addOffset("QUIVER", 0.0, 0.0, 3.0);

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    utils.addFlightAnimation(renderer, "manta.FLIGHT", "fiskheroes:flight/propelled.anim.json");
    utils.addHoverAnimation(renderer, "manta.HOVER", "fiskheroes:flight/idle/manta");

    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        blade.unfold = entity.getInterpolatedData("fiskheroes:blade_timer");

        var f = Math.min(blade.unfold * 5, 1);
        blade.setOffset(2.9 + 0.35 * f, 6.0 + 2.5 * f, 0.0);
        blade.render();

        if (!isFirstPersonArm) {
            jetpack.render(entity);
        }

    if (renderLayer == "BOOTS") {
            var boost = entity.getInterpolatedData("fiskheroes:flight_boost_timer");
            booster_boots.progress = entity.getInterpolatedData("fiskheroes:dyn/booster_timer");
            booster_boots.speedScale = 0.5 * boost;
            booster_boots.flutter = 1 + boost;

            booster_boots.setRotation(20 - 10 * boost, 0, 0);
            booster_boots.render();
        }
    }
    if (renderLayer == "HELMET") {
        overlay.opacity = entity.getInterpolatedData("fiskheroes:dyn/steel_timer");
        overlay.render();

        metal_heat.opacity = entity.getInterpolatedData("fiskheroes:metal_heat");
        metal_heat.render();
    }
}