extend("fiskheroes:hero_basic");
loadTextures({
	"layer1": "eden:mera_layer1",
	"layer2": "eden:mera_layer2",
    "boots": "eden:mera_boots",
    "pants": "eden:mera_pants",
    "segment": "eden:water_octopus_arm",
    "claw": "eden:water_octopus_claw",
    "claw_lights": "eden:water_octopus_claw_lights",
    "mera_magic": "eden:mera_magic",
    "atlantean_magic": "mera_magic"
});

var utils = implement("fiskheroes:external/utils");

var spell;

function init(renderer) {
    parent.init(renderer);
    renderer.setLights((entity, renderLayer) => {
        if (renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || renderLayer == "CHESTPLATE")

        return entity.getData("fiskheroes:tentacles") ? "mera_magic" : "lights";
    });

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    var oct_arm = utils.createModel(renderer, "eden:oct_arm", "segment", "claw_lights");
    var oct_tip = utils.createModel(renderer, "eden:oct_tip", "claw", "claw_lights");
    oct_tip.bindAnimation("eden:ock_claw").setData((entity, data) => {
        var t = entity.as("TENTACLE");
        data.load(0, 1 - Math.min(t.getCaster().getInterpolatedData("fiskheroes:tentacle_extend_timer") * 2, 1));
        data.load(1, t.getIndex());
        data.load(2, t.getGrabTimer());
        data.load(3, t.getStrikeTimer());
    });

    var tentacles = renderer.bindProperty("fiskheroes:tentacles").setTentacles([
        { "offset": [2.0, -4.5, -2.0], "direction": [13.0, 10.0, -10.0] },
        { "offset": [-2.0, -4.5, -2.0], "direction": [-13.0, 10.0, -10.0] },
        { "offset": [2.0, -7.5, -2.0], "direction": [13.0, -10.0, -10.0] },
        { "offset": [-2.0, -7.5, -2.0], "direction": [-13.0, -10.0, -10.0] },
        { "offset": [2.0, -12.0, 0.0], "direction": [25.0, -12.0, 0.0]},
        { "offset": [-2.0, -12.0, 0.0], "direction": [-25.0, -12.0, 0.0]}
    ]);
    tentacles.anchor.set("body");
    tentacles.setSegmentModel(oct_arm);
    tentacles.setHeadModel(oct_tip);
    tentacles.segmentLength = 3.5;
    tentacles.segments = 10;

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(0x87cefa);
    magic.colorEarthCrack.set(0x87cefa);
    magic.colorAtmosphere.set(0x87cefa);
    magic.colorWhip.set(0x87cefa);

    var forcefield = renderer.bindProperty("fiskheroes:forcefield");
    forcefield.color.set(0x87cefa);
    forcefield.setShape(38, 20).setOffset(0.0, 6.0, 0.0).setScale(1.25);
    forcefield.setCondition(entity => {
        forcefield.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer") * 0.15;
        return true;
    });

    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:crab_cannon", "body", 0x87cefa, [
        { "firstPerson": [-3.75, 3.0, -8.0], "offset": [0.5, 12.0, 0.0], "size": [3.0, 3.0], "anchor": "leftArm" },
        { "offset": [6.75, 10.0, 3.0], "size": [2.0, 2.0] },
        { "offset": [10.0, 0.5, 3.0], "size": [2.0, 2.0] },
        { "offset": [6.5, -4.5, 3.0], "size": [2.0, 2.0] },
        { "offset": [-6.75, 10.0, 3.0], "size": [2.0, 2.0] },
        { "offset": [-10.0, 0.5, 3.0], "size": [2.0, 2.0] },
        { "offset": [-6.5, -4.5, 3.0], "size": [2.0, 2.0] }
    ]);

	utils.bindCloud(renderer, "fiskheroes:telekinesis", "fiskheroes:breach");

    utils.bindParticles(renderer, "eden:water_eyes").setCondition(entity => entity.getData("fiskheroes:beam_charging") && entity.getData("fiskheroes:beam_charge") < 1);

    utils.bindParticles(renderer, "fiskheroes:killer_frost_ice").setCondition(entity => entity.getData("fiskheroes:beam_charging") && entity.getData("fiskheroes:beam_charge") < 1);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

    chest = renderer.createEffect("fiskheroes:chest");
    chest.setExtrude(1).setYOffset(1);

    atlantean_magic = renderer.createEffect("fiskheroes:overlay");
    atlantean_magic.texture.set(null, "mera_magic");

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    renderer.removeCustomAnimation("basic.BLOCKING");
    addAnimationWithData(renderer, "basic.BLOCKING", "fiskheroes:dual_aiming", "fiskheroes:shield_blocking_timer")
        .priority = -5;

    utils.addHoverAnimation(renderer, "strange.HOVER", "fiskheroes:flight/idle/neutral");
    utils.addFlightAnimation(renderer, "strange.FLIGHT", "fiskheroes:flight/levitate.anim.json", (entity, data) => {
        data.load(entity.getInterpolatedData("fiskheroes:flight_timer"));
    });

    addAnimationWithData(renderer, "iron_man.LAND", "fiskheroes:superhero_landing", "fiskheroes:dyn/superhero_landing_timer")
        .priority = -8;

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

    addAnimation(renderer, "basic.AIMING", "fiskheroes:dual_aiming").setData((entity, data) => {
        var charge = entity.getInterpolatedData("fiskheroes:beam_charge");
        data.load(Math.max(entity.getInterpolatedData("fiskheroes:aiming_timer"), entity.getData("fiskheroes:beam_charging") ? Math.min(charge * 3, 1) : Math.max(charge * 5 - 4, 0)));
    });
}

function render(entity, renderLayer, isFirstPersonArm) {
        if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
            chest.render();
        }
        if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
            atlantean_magic.opacity = entity.getInterpolatedData("fiskheroes:spellcast_timer");
            atlantean_magic.render();
        }
        if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
            atlantean_magic.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer");
            atlantean_magic.render();
        }
        if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
            atlantean_magic.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
            atlantean_magic.render();
        }
}