extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:muerto_layer1",
    "layer2": "eden:muerto_layer2",
    "hat": "eden:muerto_sombrero"
});

var utils = implement("fiskheroes:external/utils");

var sombrero;

function initEffects(renderer) {

    var model = renderer.createResource("MODEL", "fiskheroes:sombrero");
    model.texture.set("hat");
    sombrero = renderer.createEffect("fiskheroes:model").setModel(model);
    sombrero.anchor.set("head");
}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    parent.initAnimations(renderer);
    utils.addFlightAnimation(renderer, "mmc.FLIGHT", "fiskheroes:flight/martian_comics.anim.json");
    utils.addHoverAnimation(renderer, "mmc.HOVER", "fiskheroes:flight/idle/martian_comics");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm) {
        if (renderLayer == "HELMET") 
            sombrero.render();
         }
}