extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:namor_layer1",
    "layer2": "eden:namor_layer2",
    "trident": "eden:trident",
    "wings": "eden:namor_wings"
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var namor_trident;
var namor_trident_back;

function init(renderer) {
    parent.init(renderer);

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    speedster.init(renderer, "eden:aquaman_blur");

    namor_trident = renderer.createEffect("fiskheroes:model");
    namor_trident.setModel(utils.createModel(renderer, "eden:namor_trident", "trident", null));
    namor_trident.anchor.set("rightArm");
    namor_trident.mirror = false;

    namor_trident_back = renderer.createEffect("fiskheroes:model");
    namor_trident_back.setModel(utils.createModel(renderer, "eden:namor_trident_back", "trident", null));
    namor_trident_back.anchor.set("body");
    namor_trident_back.mirror = false;

    var model = renderer.createResource("MODEL", "eden:namor_wings");
    model.texture.set("wings");
    namor_wings = renderer.createEffect("fiskheroes:model").setModel(model);
    namor_wings.anchor.set("rightLeg");

    var model = renderer.createResource("MODEL", "eden:namor_wings_l");
    model.texture.set("wings");
    namor_wings_r = renderer.createEffect("fiskheroes:model").setModel(model);
    namor_wings_r.anchor.set("rightLeg");

    var model = renderer.createResource("MODEL", "eden:namor_wings_l");
    model.texture.set("wings");
    namor_wings_l = renderer.createEffect("fiskheroes:model").setModel(model);
    namor_wings_l.anchor.set("leftLeg");

    var model = renderer.createResource("MODEL", "eden:namor_wings");
    model.texture.set("wings");
    namor_wings_lr = renderer.createEffect("fiskheroes:model").setModel(model);
    namor_wings_lr.anchor.set("leftLeg");

    var color = 0x0049FF;

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(color);
    magic.colorEarthCrack.set(color);
    magic.colorAtmosphere.set(color);
    magic.colorWhip.set(color);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    addAnimationWithData(renderer, "iron_man.LAND", "fiskheroes:superhero_landing", "fiskheroes:dyn/superhero_landing_timer")
        .priority = -8;

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

        utils.addFlightAnimation(renderer, "mmc.FLIGHT", "fiskheroes:flight/martian_comics.anim.json");
        utils.addHoverAnimation(renderer, "mmc.HOVER", "fiskheroes:flight/idle/martian_comics");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm) {
        if (renderLayer == "CHESTPLATE") {
            namor_wings.render();

            var blade_anchor = namor_wings.anchor.set("rightLeg");
            var blade_offSet = namor_wings.setOffset(-2, 18, 2);
            var blade_rot = namor_wings.setRotation(0, 0, 0);
            namor_wings.anchor = blade_anchor, blade_offSet, blade_rot;

            namor_wings_r.render();

            var blade_anchor = namor_wings_r.anchor.set("rightLeg");
            var blade_offSet = namor_wings_r.setOffset(-8, 18, 2);
            var blade_rot = namor_wings_r.setRotation(0, 0, 0);
            namor_wings_r.anchor = blade_anchor, blade_offSet, blade_rot;

            namor_wings_l.render();

            var blade_anchor = namor_wings_l.anchor.set("leftLeg");
            var blade_offSet = namor_wings_l.setOffset(-8, 18, 2);
            var blade_rot = namor_wings_l.setRotation(0, 0, 0);
            namor_wings_l.anchor = blade_anchor, blade_offSet, blade_rot;

            namor_wings_lr.render();

            var blade_anchor = namor_wings_lr.anchor.set("leftLeg");
            var blade_offSet = namor_wings_lr.setOffset(-2, 18, 2);
            var blade_rot = namor_wings_lr.setRotation(0, 0, 0);
            namor_wings_lr.anchor = blade_anchor, blade_offSet, blade_rot;
        }
    }
    if (renderLayer == "CHESTPLATE") {
        namor_trident.opacity = entity.getData("fiskheroes:shield");
        namor_trident.render();

        var blade_anchor = namor_trident.anchor.set("rightArm");
        var blade_offSet = namor_trident.setOffset(0.8, 7.8, 5.3);
        var blade_rot = namor_trident.setRotation(90, 0, 0);
        namor_trident.anchor = blade_anchor, blade_offSet, blade_rot;

        namor_trident_back.opacity = entity.getData("fiskheroes:shield") < 1;
        namor_trident_back.render();

        var blade_anchor = namor_trident_back.anchor.set("body");
        var blade_offSet = namor_trident_back.setOffset(5.8, 7.6, 2.3);
        var blade_rot = namor_trident_back.setRotation(0, 0, 0);
        namor_trident_back.anchor = blade_anchor, blade_offSet, blade_rot;
    }
       }


