extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:neptune_layer1",
    "layer2": "eden:neptune_layer2",
    "trident": "eden:mace"
});

var utils = implement("fiskheroes:external/utils");
var telekinesis;

var trident;

var trident_back;

function init(renderer) {
    parent.init(renderer);
}

function initEffects(renderer) {

    trident = renderer.createEffect("fiskheroes:model");
    trident.setModel(utils.createModel(renderer, "eden:trident", "trident", null));
    trident.anchor.set("rightArm");
    trident.mirror = false;

    trident_back = renderer.createEffect("fiskheroes:model");
    trident_back.setModel(utils.createModel(renderer, "eden:trident_back", "trident", null));
    trident_back.anchor.set("body");
    trident_back.mirror = false;

    var forcefield = renderer.bindProperty("fiskheroes:forcefield");
    forcefield.color.set(0x87cefa);
    forcefield.setShape(36, 18).setOffset(0.0, 6.0, 0.0).setScale(1.25);
    forcefield.setCondition(entity => {
        forcefield.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer") * 0.15;
        return true;
    });
	
    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:crab_cannon", "body", 0x87cefa, [
        { "firstPerson": [-3.75, 3.0, -8.0], "offset": [0.5, 12.0, 0.0], "size": [3.0, 3.0], "anchor": "leftArm" },
        { "firstPerson": [3.75, 3.0, -8.0], "offset": [-0.5, 12.0, 0.0], "size": [3.0, 3.0], "anchor": "rightArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));        

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;
	
	utils.bindParticles(renderer, "fiskheroes:harbinger_glow");

	utils.bindCloud(renderer, "fiskheroes:telekinesis", "fiskheroes:breach");

    utils.setOpacityWithData(renderer, 0.0, 1.0, "fiskheroes:shadowform_timer");
    utils.bindCloud(renderer, "fiskheroes:particle_cloud", "fiskheroes:breach").setCondition(entity => entity.getData("fiskheroes:shadowform"));
    utils.bindTrail(renderer, "fiskheroes:anti_monitor").setCondition(entity => entity.getData("fiskheroes:size_state") > 0);
}
function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.AIMING");
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimation(renderer, "basic.AIMING", "fiskheroes:dual_aiming").setData((entity, data) => {
        var charge = entity.getInterpolatedData("fiskheroes:beam_charge");
        data.load(Math.max(entity.getInterpolatedData("fiskheroes:aiming_timer"), entity.getData("fiskheroes:beam_charging") ? Math.min(charge * 3, 1) : Math.max(charge * 5 - 4, 0)));
    });

    utils.addFlightAnimation(renderer, "mmc.FLIGHT", "fiskheroes:flight/martian_comics.anim.json");
    utils.addHoverAnimation(renderer, "mmc.HOVER", "fiskheroes:flight/idle/martian_comics");

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        trident.opacity = entity.getData("fiskheroes:shield");
        trident.render();

        var blade_anchor = trident.anchor.set("rightArm");
        var blade_offSet = trident.setOffset(0.8, 7.8, 3.3);
        var blade_rot = trident.setRotation(90, 0, 0);
        trident.anchor = blade_anchor, blade_offSet, blade_rot;

        trident_back.opacity = entity.getData("fiskheroes:shield") < 1;
        trident_back.render();

        var blade_anchor = trident_back.anchor.set("body");
        var blade_offSet = trident_back.setOffset(2.8, 14.8, 2.3);
        var blade_rot = trident_back.setRotation(0, 0, 0);
        trident_back.anchor = blade_anchor, blade_offSet, blade_rot;

    }
}