extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:nightwing_layer1",
    "layer2": "eden:nightwing_layer2",
    "web_wings": "eden:nightwings_wings",

    "rope": "eden:ace_rope",
    "grapple": "eden:ace_rope_grappler",
    "grappler": "eden:batman_grappler",
    "baton": "eden:nightwing_baton",
    "baton_lights": "eden:nightwing_baton_lights"
});

var utils = implement("fiskheroes:external/utils");

var web_wings;

var nightwing_baton;

var nightwing_baton_back;

function init(renderer) {
    parent.init(renderer);
	
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    var webs = renderer.bindProperty("fiskheroes:webs");
    webs.textureRope.set("rope");
    webs.textureRopeBase.set("grapple");

    web_wings = renderer.createEffect("fiskheroes:wingsuit");
    web_wings.texture.set("web_wings");

    
    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "body", "scale": 0.535, "offset": [-5.03, 1.28, 2.43], "rotation": [-150.0, 90.0, 0.0] }
    ]);

    var model_grappler = renderer.createResource("MODEL", "eden:grappler");
    model_grappler.texture.set("grappler");
    grappler = renderer.createEffect("fiskheroes:model").setModel(model_grappler);
    grappler.anchor.set("rightArm");
    grappler.setScale(2);

    nightwing_baton = renderer.createEffect("fiskheroes:model");
    nightwing_baton.setModel(utils.createModel(renderer, "eden:nightwing_baton", "baton", "baton_lights"));
    nightwing_baton.anchor.set("rightArm");
    nightwing_baton.mirror = true;

    nightwing_baton_back = renderer.createEffect("fiskheroes:model");
    nightwing_baton_back.setModel(utils.createModel(renderer, "eden:nightwing_baton_back", "baton", null));
    nightwing_baton_back.anchor.set("rightArm");
    nightwing_baton_back.mirror = false;

    utils.bindBeam(renderer, "fiskheroes:energy_manipulation", "fiskheroes:energy_discharge", "rightArm", 0xedeeee, [
        { "firstPerson": [-2.5, 0.0, -7.0], "offset": [-0.5, 19.0, -12.0], "size": [1.5, 1.5] }
    ]);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = true;

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.AIMING");

    addAnimationWithData(renderer, "spiderman.AIMING", "fiskheroes:web_aim_right", "fiskheroes:web_aim_right_timer")
        .priority = 2;

    addAnimationWithData(renderer, "spiderman.AIMING_LEFT", "fiskheroes:web_aim_left", "fiskheroes:web_aim_left_timer")
        .priority = 2;

    addAnimationWithData(renderer, "spiderman.WEB_RAPPEL", "fiskheroes:web_rappel", "fiskheroes:web_rappel_timer")
        .priority = 5;

    utils.addAnimationEvent(renderer, "WEBSWING_DEFAULT", "fiskheroes:swing_default");
    utils.addAnimationEvent(renderer, "WEBSWING_RIGHT", "fiskheroes:swing_right");
    utils.addAnimationEvent(renderer, "WEBSWING_LEFT", "fiskheroes:swing_left");
    utils.addAnimationEvent(renderer, "WEBSWING_TRICK_DEFAULT", [
        "fiskheroes:swing_roll",
        "fiskheroes:swing_roll2",
        "fiskheroes:swing_roll5"
    ]);
    utils.addAnimationEvent(renderer, "WEBSWING_TRICK_RIGHT", "fiskheroes:swing_rotate_right");
    utils.addAnimationEvent(renderer, "WEBSWING_TRICK_LEFT", "fiskheroes:swing_rotate_left");
    utils.addAnimationEvent(renderer, "WEBSWING_ZIP", "fiskheroes:swing_zip");
    utils.addAnimationEvent(renderer, "WEBSWING_DIVE", [
        "fiskheroes:swing_dive",
        "fiskheroes:swing_dive2"
    ]);
    utils.addAnimationEvent(renderer, "WEBSWING_LEAP", "fiskheroes:swing_springboard");
    utils.addAnimationEvent(renderer, "WEBSWING_SHOOT_RIGHT", "fiskheroes:web_swing_shoot_right");
    utils.addAnimationEvent(renderer, "WEBSWING_SHOOT_LEFT", "fiskheroes:web_swing_shoot_left");
    utils.addAnimationEvent(renderer, "WEBSHOOTER_SHOOT_RIGHT", "fiskheroes:web_shoot_right");
    utils.addAnimationEvent(renderer, "WEBSHOOTER_SHOOT_LEFT", "fiskheroes:web_shoot_left");
    utils.addAnimationEvent(renderer, "CEILING_CRAWL", "fiskheroes:crawl_ceiling");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        web_wings.unfold = entity.getInterpolatedData("fiskheroes:wing_animation_timer");
        web_wings.render();
    }
    if (renderLayer == "CHESTPLATE") {
        if (entity.getData("fiskheroes:blade_timer") > 0.9) {
            var blade_anchor = grappler.anchor.set("rightArm");
            var blade_offSet = grappler.setOffset(-2.4, 16.8, 17.3);
            var blade_rot = grappler.setRotation(55, -75, -25);
            

			
            grappler.anchor = blade_anchor, blade_offSet, blade_rot;
            grappler.render();
        }


}
if (renderLayer == "CHESTPLATE") {
    nightwing_baton.opacity = entity.getData("fiskheroes:shield");
    nightwing_baton.render();

    var blade_anchor = nightwing_baton.anchor.set("rightArm");
    var blade_offSet = nightwing_baton.setOffset(0.8, 7.8, -8.3);
    var blade_rot = nightwing_baton.setRotation(90, 0, 0);
    nightwing_baton.anchor = blade_anchor, blade_offSet, blade_rot;

    nightwing_baton_back.opacity = entity.getData("fiskheroes:shield") < 1;
    nightwing_baton_back.render();

    var blade_anchor = nightwing_baton_back.anchor.set("body");
    var blade_offSet = nightwing_baton_back.setOffset(-1.0, 3.6, 0.1);
    var blade_rot = nightwing_baton_back.setRotation(0, 0, 0);
    nightwing_baton_back.anchor = blade_anchor, blade_offSet, blade_rot;
}
}