extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:ocean_master_layer1",
    "layer2": "eden:ocean_master_layer2",
    "trident": "eden:trident",
    "cape": "eden:ocean_master_cape"
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");
var capes = implement("fiskheroes:external/capes");

var trident;

var cape;

var ears;

function init(renderer) {
    parent.init(renderer);

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    speedster.init(renderer, "eden:ocean_master_blur");

    var forcefield = renderer.bindProperty("fiskheroes:forcefield");
    forcefield.color.set(0xFFFF55);
    forcefield.setShape(36, 18).setOffset(0.0, 6.0, 0.0).setScale(1.25);
    forcefield.setCondition(entity => {
        forcefield.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer") * 0.15;
        return true;
    });

    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.weight = 1.3;
    physics.maxFlare = 0.6;
    physics.flareDegree = 1.5;
    physics.flareFactor = 1.2;
    physics.flareElasticity = 5;
    cape = capes.createDefault(renderer, 24, "fiskheroes:cape_default.mesh.json", physics);
    cape.effect.texture.set("cape");
    cape.effect.width = 16;

    trident = renderer.createEffect("fiskheroes:model");
    trident.setModel(utils.createModel(renderer, "eden:master_trident", "trident", null));
    trident.anchor.set("rightArm");
    trident.mirror = false;

    trident_back = renderer.createEffect("fiskheroes:model");
    trident_back.setModel(utils.createModel(renderer, "eden:master_trident_back", "trident", null));
    trident_back.anchor.set("rightArm");
    trident_back.mirror = false;

    ears = renderer.createEffect("fiskheroes:ears");
    ears.anchor.set("head");
    ears.angle = 20;
    ears.inset = 0.075;

    var color = 0xFFFF55;

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(color);
    magic.colorEarthCrack.set(color);
    magic.colorAtmosphere.set(color);
    magic.colorWhip.set(color);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addFlightAnimation(renderer, "shazam.FLIGHT", "fiskheroes:flight/default.anim.json");
    utils.addHoverAnimation(renderer, "shazam.HOVER", "fiskheroes:flight/idle/default");

    addAnimationWithData(renderer, "iron_man.LAND", "fiskheroes:superhero_landing", "fiskheroes:dyn/superhero_landing_timer")
        .priority = -8;

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        trident.opacity = entity.getData("fiskheroes:shield");
        trident.render();

        var blade_anchor = trident.anchor.set("rightArm");
        var blade_offSet = trident.setOffset(1.4, 8.8, 1.3);
        var blade_rot = trident.setRotation(90, 0, 0);
        trident.anchor = blade_anchor, blade_offSet, blade_rot;

        trident_back.opacity = entity.getData("fiskheroes:shield") < 1;
        trident_back.render();

        var blade_anchor = trident_back.anchor.set("body");
        var blade_offSet = trident_back.setOffset(2.8, 6.6, 2.3);
        var blade_rot = trident_back.setRotation(0, 0, 0);
        trident_back.anchor = blade_anchor, blade_offSet, blade_rot;
    }
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        cape.render(entity);
    }
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        ears.render();
    }
       }


