extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:pack_hunter_layer1",
    "layer2": "eden:pack_hunter_layer2",
    "segment": "eden:raptor_tail",
    "claw": "eden:tail_tip"
});

var utils = implement("fiskheroes:external/utils");

function init(renderer) {
    parent.init(renderer);
	
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    var oct_arm = utils.createModel(renderer, "eden:oct_arm", "segment");
    var oct_tip = utils.createModel(renderer, "eden:oct_tip", "claw");
    var tentacles = renderer.bindProperty("fiskheroes:tentacles").setTentacles([
        { "offset": [2.0, -10.0, -2.0], "direction": [10.0, 0.0, -10.0] }

    ]);
    tentacles.anchor.set("body");
    tentacles.setSegmentModel(oct_arm);
	tentacles.setHeadModel(oct_tip);
    tentacles.segmentLength = 2.0;
    tentacles.segments = 10;
	
}



