extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:raptor_runner_layer1",
    "layer2": "eden:raptor_runner_layer2",
    "shield": "eden:raptor_claw",
    "tail": "eden:raptor_runner_tail",
});

var speedster = implement("fiskheroes:external/speedster_utils");

var utils = implement("fiskheroes:external/utils");

var raptor_tail;

function initEffects(renderer) {

    speedster.init(renderer, "eden:raptor_blur");


    shield = renderer.createEffect("fiskheroes:shield");
    shield.texture.set("shield");
    shield.anchor.set("rightArm");
    shield.setCurve(25.0, 35.0);
    shield.mirror = true;

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

    raptor_tail = renderer.createEffect("fiskheroes:model");
    raptor_tail.setModel(utils.createModel(renderer, "eden:raptor_tail", "tail"));
    raptor_tail.anchor.set("body");
    raptor_tail.mirror = false;

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        shield.unfold = entity.getInterpolatedData("fiskheroes:shield_timer");
        shield.setOffset(2.9 + 1.35 * Math.min(shield.unfold * 5, 1), 5.0, 0.0);
        shield.render();
    }
    if (renderLayer == "CHESTPLATE") {
        raptor_tail.render();

        var blade_anchor = raptor_tail.anchor.set("body");
        var blade_offSet = raptor_tail.setOffset(-1.4, 13.3, 3.0);
        var blade_rot = raptor_tail.setRotation(-100, 90, 0);
        raptor_tail.anchor = blade_anchor, blade_offSet, blade_rot;
    }
}