extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:raven_layer1",
    "layer2": "eden:raven_layer2",
    "segment": "eden:raven_arm",
    "claw": "eden:raven_claw",
    "aura" : "eden:raven_aura",
    "cape" : "eden:raven_cape",
    "raven": "eden:raven"
});

var utils = implement("fiskheroes:external/utils");

var glyphs = implement("fiskheroes:external/mysterio_glyph");

var glyph;
var glyph_big;

var aura;

var raven;

var capes = implement("fiskheroes:external/capes");

var cape;

function init(renderer) {
    parent.init(renderer);

    parent.init(renderer);
    renderer.setTexture((entity, renderLayer) => {
        if (renderLayer == "HELMET" && entity.getData("fiskheroes:mask_open_timer2") > 0) {
            return "layer1";
        }
        return renderLayer == "LEGGINGS" ? "layer2" : "layer1";
    });

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.weight = 1.3;
    physics.maxFlare = 0.6;
    physics.flareDegree = 1.5;
    physics.flareFactor = 1.2;
    physics.flareElasticity = 5;
    cape = capes.createDefault(renderer, 24, "fiskheroes:cape_default.mesh.json", physics);
    cape.effect.texture.set("cape");
    cape.effect.width = 16;

    var oct_arm = utils.createModel(renderer, "eden:oct_arm", "segment");
    var oct_tip = utils.createModel(renderer, "eden:oct_tip", "claw");
    oct_tip.bindAnimation("eden:ock_claw").setData((entity, data) => {
        var t = entity.as("TENTACLE");
        data.load(0, 1 - Math.min(t.getCaster().getInterpolatedData("fiskheroes:tentacle_extend_timer") * 2, 1));
        data.load(1, t.getIndex());
        data.load(2, t.getGrabTimer());
        data.load(3, t.getStrikeTimer());
    });

    var tentacles = renderer.bindProperty("fiskheroes:tentacles").setTentacles([
        { "offset": [2.0, -4.5, -2.0], "direction": [13.0, 10.0, -10.0] },
        { "offset": [-2.0, -4.5, -2.0], "direction": [-13.0, 10.0, -10.0] },
        { "offset": [2.0, -7.5, -2.0], "direction": [13.0, -10.0, -10.0] },
        { "offset": [-2.0, -7.5, -2.0], "direction": [-13.0, -10.0, -10.0] },
        { "offset": [2.0, -12.0, 0.0], "direction": [25.0, -12.0, 0.0]},
        { "offset": [-2.0, -12.0, 0.0], "direction": [-25.0, -12.0, 0.0]}
    ]);
    tentacles.anchor.set("body");
    tentacles.setSegmentModel(oct_arm);
    tentacles.setHeadModel(oct_tip);
    tentacles.segmentLength = 3.5;
    tentacles.segments = 10;

    raven = renderer.createEffect("fiskheroes:model");
    raven.setModel(utils.createModel(renderer, "eden:raven", "raven", null));
    raven.anchor.ignoreAnchor(true);
    raven.setScale(1);

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(0xFF55FF);
    magic.colorEarthCrack.set(0xFF55FF);
    magic.colorAtmosphere.set(0xFF55FF);
    magic.colorWhip.set(0xFF55FF);

    var color = 0xFF55FF;
    glyph = glyphs.create(renderer, color, "rightArm", "fiskheroes:mysterio_glyph", true);
    glyph.setOffset(1.0, 13.0, 0.0).setRotation(0.0, 0.0, 10.0).setScale(5.2);
    glyph_big = glyphs.create(renderer, color, "head", "fiskheroes:mysterio_glyph_big", false);
    glyph_big.setScale(16);

    utils.setOpacityWithData(renderer, 0.5, 1.0, "fiskheroes:intangibility_timer");

    // Antimatter Beam
    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:energy_projection", "body", 0xFF55FF, [
        { "firstPerson": [0.0, 6.0, 0.0], "offset": [0.0, 5.0, -4.0], "size": [4.0, 4.0] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_energy_projection"));

    chest = renderer.createEffect("fiskheroes:chest");
    chest.setExtrude(1).setYOffset(1);

    aura = renderer.createEffect("fiskheroes:overlay");
    aura.texture.set(null, "aura");

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    renderer.removeCustomAnimation("basic.AIMING");
    renderer.removeCustomAnimation("basic.ENERGY_PROJ");
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimation(renderer, "basic.AIMING", "fiskheroes:dual_aiming").setData((entity, data) => {
        var charge = entity.getInterpolatedData("fiskheroes:beam_charge");
        data.load(Math.max(entity.getInterpolatedData("fiskheroes:aiming_timer"), entity.getData("fiskheroes:beam_charging") ? Math.min(charge * 3, 1) : Math.max(charge * 5 - 4, 0)));
    });

    utils.addFlightAnimation(renderer, "mysterio.FLIGHT", "fiskheroes:flight/default.anim.json");
    utils.addHoverAnimation(renderer, "mysterio.HOVER", "fiskheroes:flight/idle/default");
}
function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        chest.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:energy_projection_timer");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:flight_timer");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:tentacle_extend_timer");
        aura.render();
    }
    if (renderLayer == "CHESTPLATE") {
        raven.opacity = entity.getData("fiskheroes:tentacle_extend_timer");
        raven.render();
    
        var blade_anchor = raven.anchor.ignoreAnchor(true);
        var blade_offSet = raven.setOffset(2.0, -2, 15);
        var blade_rot = raven.setRotation(-90, 90, 90);
        raven.anchor = blade_anchor, blade_offSet, blade_rot;
    }
    if (renderLayer == "CHESTPLATE") {
        raven.opacity = entity.getData("fiskheroes:energy_projection_timer");
        raven.render();
    
        var blade_anchor = raven.anchor.ignoreAnchor(true);
        var blade_offSet = raven.setOffset(2.0, -2, 15);
        var blade_rot = raven.setRotation(-90, 90, 90);
        raven.anchor = blade_anchor, blade_offSet, blade_rot;
    }
    if (!isFirstPersonArm && renderLayer == "HELMET") {
        overlay.opacity = 1 - entity.getInterpolatedData("fiskheroes:mask_open_timer2");

        if (overlay.opacity < 1) {
            overlay.render();
        }

        renderGlyph(entity, isFirstPersonArm);
    }
    else if (renderLayer == "CHESTPLATE") {
        glyph.render(entity.getInterpolatedData("fiskheroes:aimed_timer"));

        if (isFirstPersonArm) {
            renderGlyph(entity, isFirstPersonArm);
        }
        else {
            cape.render(entity);
        }
    }
}

function renderGlyph(entity, isFirstPersonArm) {
    var charge = entity.getInterpolatedData("fiskheroes:beam_charge");
    charge = entity.getData("fiskheroes:beam_charging") ? Math.min(charge * 2, 1) : Math.max(charge * 3 - 2, 0);

    if (isFirstPersonArm) {
        glyph_big.setOffset(0, 3, -20).setRotation(80, 0, 0);
        glyph_big.ignoreAnchor(true);
    }
    else {
        glyph_big.setOffset(0, 5, -24).setRotation(90, 0, 0);
        glyph_big.ignoreAnchor(false);
    }

    glyph_big.render(charge);
}
