extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:shazam_billy",
    "layer2": "eden:shazam_billy",
    "shazam": "eden:shazam_layer1",
    "cape": "eden:shazam_cape.tx.json",
    "lightning" : "eden:shazam_lights"
});

var utils = implement("fiskheroes:external/utils");
var capes = implement("fiskheroes:external/capes");
var speedster = implement("fiskheroes:external/speedster_utils");

var cape;

var overlay;

function init(renderer) {
    parent.init(renderer);

    renderer.setLights((entity, renderLayer) => {
        if (renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || renderLayer == "CHESTPLATE")

        return entity.getData("fiskheroes:dyn/steel_timer") ? "lightning" : "lights";
    });

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.maxFlare = 0.4;
    cape = capes.createDefault(renderer, 17, "fiskheroes:cape_default.mesh.json", physics);
    cape.effect.texture.set("cape");
    cape.effect.width = 12;

    overlay = renderer.createEffect("fiskheroes:overlay");
    overlay.texture.set("shazam");

    glow = renderer.createEffect("fiskheroes:glowerlay");
    glow.color.set(0xFFFFFF);

    
    utils.bindParticles(renderer, "fiskheroes:harbinger_glow").setCondition(entity => entity.getData("fiskheroes:dyn/steel_timer") > 0 && entity.getData('fiskheroes:dyn/steel_timer') < 1);

    speedster.init(renderer, "fiskheroes:shazam");

    utils.bindBeam(renderer, "fiskheroes:lightning_cast", "fiskheroes:lightning_cast", "rightArm", 0xD9FFFF, [
        { "firstPerson": [-8.0, 4.5, -10.0], "offset": [-0.5, 9.0, 0.0], "size": [0.75, 0.75] }
    ]);

    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:lightning_cast", "rightArm", 0xedeeee, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
        { "firstPerson": [4.5, 3.75, -8.0], "offset": [0.5, 9.0, 0.0], "size": [3.0, 3.0], "anchor": "leftArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));
}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addFlightAnimation(renderer, "shazam.FLIGHT", "fiskheroes:flight/default.anim.json");
    utils.addHoverAnimation(renderer, "shazam.HOVER", "fiskheroes:flight/idle/default");

    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "basic.AIMING", "fiskheroes:dual_aiming", "fiskheroes:beam_charge");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        overlay.opacity = entity.getInterpolatedData("fiskheroes:dyn/steel_timer");
        overlay.render();

        cape.render(entity);
    }
    glow.opacity = entity.getInterpolatedData("fiskheroes:teleport_timer");
    glow.render();
    
}
