extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:starfire_layer1",
    "layer2": "eden:starfire_layer2",

    "aura" : "eden:starfire_aura",

});

var utils = implement("fiskheroes:external/utils");

var aura;


function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    aura = renderer.createEffect("fiskheroes:overlay");
    aura.texture.set(null, "aura");

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(0x55FF55);
    magic.colorEarthCrack.set(0x55FF55);
    magic.colorAtmosphere.set(0x55FF55);
    magic.colorWhip.set(0x55FF55);

    chest = renderer.createEffect("fiskheroes:chest");
    chest.setExtrude(1).setYOffset(1);

    utils.bindBeam(renderer, "fiskheroes:repulsor_blast", "fiskheroes:repulsor_blast", "rightArm", 0x55FF55, [
        { "firstPerson": [-4.5, 3.75, -7.0], "offset": [-0.5, 9.0, 0.0], "size": [1.5, 1.5] }
    ]);

    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:energy_projection", "rightArm", 0x55FF55, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
        { "firstPerson": [4.5, 3.75, -8.0], "offset": [0.5, 9.0, 0.0], "size": [3.0, 3.0], "anchor": "leftArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    
    utils.addFlightAnimationWithLanding(renderer, "iron_man.FLIGHT", "fiskheroes:flight/iron_man.anim.json");
    utils.addHoverAnimation(renderer, "iron_man.HOVER", "fiskheroes:flight/idle/iron_man");
    utils.addAnimationEvent(renderer, "FLIGHT_DIVE", "fiskheroes:iron_man_dive");

    addAnimationWithData(renderer, "iron_man.LAND", "fiskheroes:superhero_landing", "fiskheroes:dyn/superhero_landing_timer")
        .priority = -8;

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:energy_projection_timer");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:flight_timer");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:aimed_timer");
        aura.render();
    }
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        chest.render();
    }

}