extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:superman_layer1",
    "layer2": "eden:superman_layer2",
    "cape": "eden:superman_cape",
    "ice_breathe": "eden:ice_breathe",
    "heat_vision": "eden:heat_vision",
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var capes = implement("fiskheroes:external/capes");

var heat_vision;

var ice_breathe;

var cape;


function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.weight = 1.3;
    physics.maxFlare = 0.6;
    physics.flareDegree = 1.5;
    physics.flareFactor = 1.2;
    physics.flareElasticity = 3;
    cape = capes.createDefault(renderer, 22, "fiskheroes:cape_default.mesh.json", physics);
    cape.effect.texture.set("cape");
    cape.effect.width = 12;

    heat_vision = renderer.createEffect("fiskheroes:overlay");
    heat_vision.texture.set(null, "heat_vision");

    ice_breathe = renderer.createEffect("fiskheroes:overlay");
    ice_breathe.texture.set(null, "ice_breathe");

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

    var beam = renderer.createResource("BEAM_RENDERER", "fiskheroes:mysterio_beam");
    utils.bindBeam(renderer, "fiskheroes:charged_beam", beam, "head", 0x4CB5FF, [
        { "firstPerson": [0.0, 4.0, 0.0], "offset": [0.0, -1.4, 0.0], "size": [3.0, 3.0] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "eden:impact_ice"));

    utils.bindParticles(renderer, "fiskheroes:black_manta_dceu_eyes").setCondition(entity => entity.getData("fiskheroes:heat_vision"));
    utils.bindBeam(renderer, "fiskheroes:heat_vision", "fiskheroes:heat_vision", "head", 0xFF0000, [
        { "firstPerson": [2.2, 0.0, 2.0], "offset": [2.2, -3.3, -4.0], "size": [1.0, 0.5] },
        { "firstPerson": [-2.2, 0.0, 2.0], "offset": [-2.2, -3.3, -4.0], "size": [1.0, 0.5] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_heat_vision"));
}
function initAnimations(renderer) {
    parent.initAnimations(renderer);
    
    utils.addFlightAnimation(renderer, "mmcw.FLIGHT", "fiskheroes:flight/default_arms_forward.anim.json");
    utils.addHoverAnimation(renderer, "mmcw.HOVER", "fiskheroes:flight/idle/neutral");

    addAnimationWithData(renderer, "iron_man.LAND", "fiskheroes:superhero_landing", "fiskheroes:dyn/superhero_landing_timer")

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "HELMET") {
        heat_vision.opacity = entity.getInterpolatedData("fiskheroes:energy_projection_timer");
        heat_vision.render();
    }
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        cape.render(entity);
    }
    if (renderLayer == "HELMET") {
        ice_breathe.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        ice_breathe.render();
    }
}