extend("fiskheroes:hero_basic");
loadTextures({
	"layer1": "eden:tempest_garth_layer1",
	"layer2": "eden:tempest_garth_layer2",
    "boots": "eden:tempest_garth_boots",
    "pants": "eden:tempest_garth_pants",
    "segment": "eden:water_octopus_arm",
    "claw": "eden:water_octopus_claw",
    "claw_lights": "eden:water_octopus_claw_lights",
    "tempest_garth_magic": "eden:tempest_garth_magic",
});

var utils = implement("fiskheroes:external/utils");
var eldritch_sword = implement("fiskheroes:external/eldritch_sword");
var mandalas = implement("fiskheroes:external/tao_mandalas");

var shield;
var sword;
var spell;

function init(renderer) {
    parent.init(renderer);
    renderer.setLights((entity, renderLayer) => {
        if (renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || renderLayer == "CHESTPLATE")

        return entity.getData("fiskheroes:tentacles") ? "tempest_garth_magic" : "lights";
    });

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    var oct_arm = utils.createModel(renderer, "eden:oct_arm", "segment", "claw_lights");
    var oct_tip = utils.createModel(renderer, "eden:oct_tip", "claw", "claw_lights");
    oct_tip.bindAnimation("eden:ock_claw").setData((entity, data) => {
        var t = entity.as("TENTACLE");
        data.load(0, 1 - Math.min(t.getCaster().getInterpolatedData("fiskheroes:tentacle_extend_timer") * 2, 1));
        data.load(1, t.getIndex());
        data.load(2, t.getGrabTimer());
        data.load(3, t.getStrikeTimer());
    });

    var tentacles = renderer.bindProperty("fiskheroes:tentacles").setTentacles([
        { "offset": [2.0, -4.5, -2.0], "direction": [13.0, 10.0, -10.0] },
        { "offset": [-2.0, -4.5, -2.0], "direction": [-13.0, 10.0, -10.0] },
        { "offset": [2.0, -7.5, -2.0], "direction": [13.0, -10.0, -10.0] },
        { "offset": [-2.0, -7.5, -2.0], "direction": [-13.0, -10.0, -10.0] },
        { "offset": [2.0, -12.0, 0.0], "direction": [25.0, -12.0, 0.0]},
        { "offset": [-2.0, -12.0, 0.0], "direction": [-25.0, -12.0, 0.0]}
    ]);
    tentacles.anchor.set("body");
    tentacles.setSegmentModel(oct_arm);
    tentacles.setHeadModel(oct_tip);
    tentacles.segmentLength = 3.5;
    tentacles.segments = 10;

    {var color = 0xFF55FF};
    var tao_mandala = renderer.createResource("SHAPE", "fiskheroes:tao_mandala");
    var beam = renderer.createResource("BEAM_RENDERER", "fiskheroes:line");
    spell = renderer.createEffect("fiskheroes:lines").setShape(tao_mandala).setRenderer(beam);
    spell.color.set(0xFF55FF);
    spell.setOffset(1.0, 8.0, 0.0).setScale(3.2);
    spell.anchor.set("rightArm");
    spell.mirror = true;

    shield = mandalas.create(renderer, color, tao_mandala, beam);
    sword = eldritch_sword.create(renderer,0x5C5CFB, beam);
    sword.setOffset(1.0, 9.4, -4.0).setRotation(10.0, 0.0, 0.0).setScale(16.0);

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(0x5C5CFB);
    magic.colorEarthCrack.set(0xFF55FF);
    magic.colorAtmosphere.set(0x5C5CFB);
    magic.colorWhip.set(0x5C5CFB);

    var forcefield = renderer.bindProperty("fiskheroes:forcefield");
    forcefield.color.set(0x5C5CFB);
    forcefield.setShape(36, 18).setOffset(0.0, 6.0, 0.0).setScale(1.25);
    forcefield.setCondition(entity => {
        forcefield.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer") * 0.15;
        return true;
    });


    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:crab_cannon", "body", 0x87cefa, [
        { "firstPerson": [-3.75, 3.0, -8.0], "offset": [0.5, 12.0, 0.0], "size": [3.0, 3.0], "anchor": "leftArm" },
        { "firstPerson": [3.75, 3.0, -8.0], "offset": [-0.5, 12.0, 0.0], "size": [3.0, 3.0], "anchor": "rightArm" }
    ]);

    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:charged_beam", "head", 0xFF55FF, [
        { "firstPerson": [3.0, 0.0, 2.0], "offset": [3.0, -4.0, -4.0], "size": [3.0, 2.0] },
        { "firstPerson": [-3.0, 0.0, 2.0], "offset": [-3.0, -4.0, -4.0], "size": [3.0, 2.0] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_charged_beam"));
    
	utils.bindCloud(renderer, "fiskheroes:telekinesis", "fiskheroes:breach");

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

    tempest_garth_magic = renderer.createEffect("fiskheroes:overlay");
    tempest_garth_magic.texture.set(null, "tempest_garth_magic");

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.AIMING");
    addAnimationWithData(renderer, "basic.AIMING", "fiskheroes:dual_aiming", "fiskheroes:aiming_timer")
        .priority = 10;

    renderer.removeCustomAnimation("basic.BLOCKING");
    addAnimationWithData(renderer, "basic.BLOCKING", "fiskheroes:dual_aiming", "fiskheroes:shield_blocking_timer")
        .priority = -5;

    addAnimationWithData(renderer, "strange.SWORD_POSE", "fiskheroes:sword_pose", "fiskheroes:blade_timer");

    utils.addHoverAnimation(renderer, "strange.HOVER", "fiskheroes:flight/idle/neutral");
    utils.addFlightAnimation(renderer, "strange.FLIGHT", "fiskheroes:flight/levitate.anim.json", (entity, data) => {
        data.load(entity.getInterpolatedData("fiskheroes:flight_timer"));
    });

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        spell.progress = entity.getInterpolatedData("fiskheroes:spellcast_timer");
        spell.render();

        shield.render(entity, isFirstPersonArm);
        sword.render(entity.getInterpolatedData("fiskheroes:blade_timer"));

        }
        if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
            tempest_garth_magic.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
            tempest_garth_magic.render();
        }
        if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
            tempest_garth_magic.opacity = entity.getInterpolatedData("fiskheroes:spellcast_timer");
            tempest_garth_magic.render();
        }
        if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
            tempest_garth_magic.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer");
            tempest_garth_magic.render();
        }
}