extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:the_first_knight_layer1",
    "layer2": "eden:the_first_knight_layer2",

    "shield": "eden:the_last_knight_shield",
    "sword": "eden:the_first_knight_sword",
    "arrow": "fiskheroes:arrow/prometheus",
    "sheath": "fiskheroes:prometheus_sheath",

    "rope": "eden:ace_rope",
    "grapple": "eden:ace_rope_grappler"
});

var utils = implement("fiskheroes:external/utils");

var sheath;

function init(renderer) {
    parent.init(renderer);
	
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    parent.initEffects(renderer);

    var equipped = renderer.bindProperty("fiskheroes:equipped_item");
    equipped.setItems([
        { "anchor": "body", "scale": 1.0, "offset": [0.0, 5.0, 2.75], "rotation": [90.0, -180.0, 0.0] }
    ]);
    equipped.addOffset("QUIVER", -0.5, 0.0, 2.36);

    sheath = renderer.createEffect("fiskheroes:model");
    sheath.setModel(utils.createModel(renderer, "fiskheroes:prometheus_sheath", "sheath"));
    sheath.anchor.set("body");

    var webs = renderer.bindProperty("fiskheroes:webs");
    webs.textureRope.set("rope");
    webs.textureRopeBase.set("grapple");

    utils.addLivery(renderer, "SHIELD", "shield");
    utils.addLivery(renderer, "CHOKUTO", "sword");
    utils.addLivery(renderer, "ARROW", "arrow");

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    renderer.reprioritizeDefaultAnimation("PUNCH", -9);
    renderer.reprioritizeDefaultAnimation("AIM_BOW", -9);
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        sheath.render();
    }
}