extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:the_last_knight_layer1",
    "layer2": "eden:the_last_knight_layer2",

    "shield": "eden:the_last_knight_shield",
    "sword": "eden:the_last_knight_sword",
    "arrow": "fiskheroes:arrow/prometheus",
    "blade": "eden:the_knight_sword",
    "blade_back": "eden:the_knight_sword_back",

    "rope": "eden:ace_rope",
    "grapple": "eden:ace_rope_grappler"
});

var utils = implement("fiskheroes:external/utils");

var sword;

var sword_back;

var sword_sheath;

function initEffects(renderer) {
    parent.initEffects(renderer);

    var equipped = renderer.bindProperty("fiskheroes:equipped_item");
    equipped.setItems([
        { "anchor": "body", "scale": 1.0, "offset": [0.0, 5.0, 2.75], "rotation": [90.0, -180.0, 0.0] }
    ]);
    equipped.addOffset("QUIVER", -0.5, 0.0, 2.36);

    var webs = renderer.bindProperty("fiskheroes:webs");
    webs.textureRope.set("rope");
    webs.textureRopeBase.set("grapple");

    utils.addLivery(renderer, "SHIELD", "shield");
    utils.addLivery(renderer, "CHOKUTO", "sword");
    utils.addLivery(renderer, "ARROW", "arrow");

    sword = renderer.createEffect("fiskheroes:model");
    sword.setModel(utils.createModel(renderer, "eden:knight_sword", "blade", null));
    sword.anchor.set("rightArm");
    sword.mirror = false;

    sword_back= renderer.createEffect("fiskheroes:model");
    sword_back.setModel(utils.createModel(renderer, "eden:sword_knight_back", "blade_back", null));
    sword_back.anchor.set("rightArm");
    sword_back.mirror = false;

    sword_sheath= renderer.createEffect("fiskheroes:model");
    sword_sheath.setModel(utils.createModel(renderer, "eden:sword_knight_sheath", "blade_back", null));
    sword_sheath.anchor.set("body");
    sword_sheath.mirror = false;

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    renderer.reprioritizeDefaultAnimation("PUNCH", -9);
    renderer.reprioritizeDefaultAnimation("AIM_BOW", -9);
}

function render(entity, renderLayer, isFirstPersonArm) {

    if (renderLayer == "CHESTPLATE") {
        sword.opacity = entity.getData("fiskheroes:shield");
        sword.render();

        var blade_anchor = sword.anchor.set("rightArm");
        var blade_offSet = sword.setOffset(0.8, 7.8, -3.2);
        var blade_rot = sword.setRotation(90, 90, 0);
        sword.anchor = blade_anchor, blade_offSet, blade_rot;

        sword_back.opacity = entity.getData("fiskheroes:shield") < 1;
        sword_back.render();

        var blade_anchor = sword_back.anchor.set("body");
        var blade_offSet = sword_back.setOffset(-3.8, 2.6, 2.3);
        var blade_rot = sword_back.setRotation(0, 0, 0);
        sword_back.anchor = blade_anchor, blade_offSet, blade_rot;

        sword_sheath.opacity = entity.getData("fiskheroes:shield");
        sword_sheath.render();

        var blade_anchor = sword_sheath.anchor.set("body");
        var blade_offSet = sword_sheath.setOffset(-3.8, 2.6, 2.3);
        var blade_rot = sword_sheath.setRotation(0, 0, 0);
        sword_sheath.anchor = blade_anchor, blade_offSet, blade_rot;

    }
    
}