extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:thunderbird_layer1",
    "layer2": "eden:thunderbird_layer2",
    "cape": "eden:thunderbird_cape",
    "thunderbird": "eden:thunderbird",
    "thunderbird": "eden:thunderbird",
    "staff": "eden:thunderbird_staff"
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var capes = implement("fiskheroes:external/capes");

var thunderbird;

var thunderbird_staff;
var thunderbird_staff_back;


function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
}

function initEffects(renderer) {
    
    speedster.init(renderer, "eden:lightning_comics_white");

    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.maxFlare = 0.4;
    cape = capes.createDefault(renderer, 17, "fiskheroes:cape_default.mesh.json", physics);
    cape.effect.texture.set("cape");
    cape.effect.width = 12;

    thunderbird = renderer.createEffect("fiskheroes:model");
    thunderbird.setModel(utils.createModel(renderer, "eden:thunderbird", "thunderbird", null));
    thunderbird.anchor.ignoreAnchor(true);
    thunderbird.setScale(1.2);

    thunderbird_staff = renderer.createEffect("fiskheroes:model");
    thunderbird_staff.setModel(utils.createModel(renderer, "eden:thunderbird_staff", "staff", null));
    thunderbird_staff.anchor.set("rightArm");
    thunderbird_staff.mirror = false;

    thunderbird_staff_back = renderer.createEffect("fiskheroes:model");
    thunderbird_staff_back.setModel(utils.createModel(renderer, "eden:thunderbird_staff_back", "staff", null));
    thunderbird_staff_back.anchor.set("body");
    thunderbird_staff_back.mirror = false;

    // Antimatter Beam
    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:energy_projection", "body", 0xedeeee, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 3.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_energy_projection"));

    // Antimatter Blast
    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:lightning_cast", "rightArm", 0xedeeee, [
        { "firstPerson": [0.0, 6.0, 0.0], "offset": [0.0, 5.0, -4.0], "size": [3.0, 3.0],"anchor": "rightArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

    utils.bindBeam(renderer, "fiskheroes:lightning_cast", "fiskheroes:energy_discharge", "rightArm", 0xedeeee, [
        { "firstPerson": [-8.0, 4.5, -10.0], "offset": [-0.5, 9.0, 0.0], "size": [2.0, 2.0] }
    ]);	
    utils.bindBeam(renderer, "fiskheroes:energy_manipulation", "fiskheroes:energy_discharge", "rightArm", 0xedeeee, [
        { "firstPerson": [-2.5, 0.0, -7.0], "offset": [-0.5, 19.0, -12.0], "size": [1.5, 1.5] }
    ]);

    renderer.bindProperty("fiskheroes:energy_bolt").color.set(0xedeeee);



}
function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addFlightAnimation(renderer, "basic.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "basic.HOVER", "fiskheroes:flight/idle/propelled_hands");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        cape.render(entity);
    }
    if (renderLayer == "CHESTPLATE") {
        thunderbird.opacity = entity.getData("fiskheroes:flight_boost_timer");
        thunderbird.render();
    
        var blade_anchor = thunderbird.anchor.ignoreAnchor(true);
        var blade_offSet = thunderbird.setOffset(2.0, 4.3, 15);
        var blade_rot = thunderbird.setRotation(-90, 90, 90);
        thunderbird.anchor = blade_anchor, blade_offSet, blade_rot;
    }
    if (renderLayer == "CHESTPLATE") {
        thunderbird_staff.opacity = entity.getData("fiskheroes:shield");
        thunderbird_staff.render();

        var blade_anchor = thunderbird_staff.anchor.set("rightArm");
        var blade_offSet = thunderbird_staff.setOffset(0.8, 7.8, 5.3);
        var blade_rot = thunderbird_staff.setRotation(90, 0, 0);
        thunderbird_staff.anchor = blade_anchor, blade_offSet, blade_rot;

        thunderbird_staff_back.opacity = entity.getData("fiskheroes:shield") < 1;
        thunderbird_staff_back.render();

        var blade_anchor = thunderbird_staff_back.anchor.set("body");
        var blade_offSet = thunderbird_staff_back.setOffset(2.8, 13.6, 2.3);
        var blade_rot = thunderbird_staff_back.setRotation(0, 0, 0);
        thunderbird_staff_back.anchor = blade_anchor, blade_offSet, blade_rot;

    }
}