extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:trike_layer1",
    "layer2": "eden:trike_layer2",
    "shield": "eden:trike_shield",
    "horns": "eden:mace",
    "trike": "eden:trike_form",
});

var utils = implement("fiskheroes:external/utils");

function initEffects(renderer) {

    trike = renderer.createEffect("fiskheroes:overlay");
    trike.texture.set(null, "trike");

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(0xedeeee);
    magic.colorAtmosphere.set(0xedeeee);

    var model = renderer.createResource("MODEL", "eden:trike_horns");
    model.texture.set("horns");
    trike_horns = renderer.createEffect("fiskheroes:model").setModel(model);
    trike_horns.anchor.set("head");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm) {
        if (renderLayer == "CHESTPLATE") {
            trike_horns.render();
        }
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        trike.opacity = entity.getInterpolatedData("fiskheroes:shield");
        trike.render();
    }
}