extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:wonder_woman_clay_layer1",
    "layer2": "eden:wonder_woman_clay_layer2",
    "lasso": "eden:trident",

    "shield": "eden:wonderwoman_shield",
    "sword": "eden:wonderwoman_sword",

    "rope": "eden:aquaman_rope",
    "grapple": "eden:aquaman_rope_tip",

    "blade": "eden:wonderwoman_sword",
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var lasso;

var lasso_body;

var chest;

var sword;

var sword_back;

function init(renderer) {
    parent.init(renderer);

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    utils.addLivery(renderer, "SHIELD", "shield");

    var webs = renderer.bindProperty("fiskheroes:webs");
    webs.textureRope.set("rope");
    webs.textureRopeBase.set("tip");

    lasso = renderer.createEffect("fiskheroes:model");
    lasso.setModel(utils.createModel(renderer, "eden:lasso", "lasso", null));
    lasso.anchor.set("rightArm");
    lasso.mirror = false;
    lasso.setScale(1.5);

    lasso_body = renderer.createEffect("fiskheroes:model");
    lasso_body.setModel(utils.createModel(renderer, "eden:lasso_body", "lasso", null));
    lasso_body.anchor.set("rightArm");
    lasso_body.mirror = false;
    lasso_body.setScale(1.0);

    sword = renderer.createEffect("fiskheroes:model");
    sword.setModel(utils.createModel(renderer, "eden:wonderwoman_sword", "blade", null));
    sword.anchor.set("rightArm");
    sword.mirror = false;

    sword_back = renderer.createEffect("fiskheroes:model");
    sword_back.setModel(utils.createModel(renderer, "eden:wonderwoman_sword_back", "blade", null));
    sword_back.anchor.set("rightArm");
    sword_back.mirror = false;

    chest = renderer.createEffect("fiskheroes:chest");
    chest.setExtrude(1).setYOffset(1);

    var color = 0xFFFF55;

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(color);
    magic.colorEarthCrack.set(color);
    magic.colorAtmosphere.set(color);
    magic.colorWhip.set(color);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

    var equipped = renderer.bindProperty("fiskheroes:equipped_item");
    equipped.setItems([
        { "anchor": "body", "scale": 1.0, "offset": [0.0, 5.0, 2.75], "rotation": [90.0, -180.0, 0.0] }
    ]);

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addFlightAnimation(renderer, "basic.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "basic.HOVER", "fiskheroes:flight/idle/propelled_hands");

    addAnimationWithData(renderer, "iron_man.LAND", "fiskheroes:superhero_landing", "fiskheroes:dyn/superhero_landing_timer")
        .priority = -8;

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

    addAnimationWithData(renderer, "wonder_woman.SWORD_POSE", "fiskheroes:sword_pose", "fiskheroes:shield_timer");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        lasso.opacity = entity.getData("fiskheroes:blade");
        lasso.render();

        var blade_anchor = lasso.anchor.set("rightArm");
        var blade_offSet = lasso.setOffset(1.8, 8.8, -2.6);
        var blade_rot = lasso.setRotation(90, 90, 0);
        lasso.anchor = blade_anchor, blade_offSet, blade_rot;

        lasso_body.opacity = entity.getData("fiskheroes:blade") < 1;
        lasso_body.render();

        var blade_anchor = lasso_body.anchor.set("body");
        var blade_offSet = lasso_body.setOffset(4.3, 9.8, -2.6);
        var blade_rot = lasso_body.setRotation(90, 90, 0);
        lasso_body.anchor = blade_anchor, blade_offSet, blade_rot;
    }
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        chest.render();
    }

    if (renderLayer == "CHESTPLATE") {
        sword.opacity = entity.getData("fiskheroes:shield");
        sword.render();

        var blade_anchor = sword.anchor.set("rightArm");
        var blade_offSet = sword.setOffset(0.8, 8.8, -2.6);
        var blade_rot = sword.setRotation(90, 90, 0);
        sword.anchor = blade_anchor, blade_offSet, blade_rot;

        sword_back.opacity = entity.getData("fiskheroes:shield") < 1;
        sword_back.render();

        var blade_anchor = sword_back.anchor.set("body");
        var blade_offSet = sword_back.setOffset(2.8, 2.6, 2.3);
        var blade_rot = sword_back.setRotation(0, 0, 0);
        sword_back.anchor = blade_anchor, blade_offSet, blade_rot;

    }
       }


