extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:wondergirl_layer1",
    "layer2": "eden:wondergirl_layer2",
    "lasso": "eden:trident",

    "rope": "eden:aquaman_rope",
    "grapple": "eden:aquaman_rope_tip"
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var lasso;

var lasso_body;

var chest;

function init(renderer) {
    parent.init(renderer);

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    var webs = renderer.bindProperty("fiskheroes:webs");
    webs.textureRope.set("rope");
    webs.textureRopeBase.set("tip");

    lasso = renderer.createEffect("fiskheroes:model");
    lasso.setModel(utils.createModel(renderer, "eden:lasso", "lasso", null));
    lasso.anchor.set("rightArm");
    lasso.mirror = false;
    lasso.setScale(1.5);

    lasso_body = renderer.createEffect("fiskheroes:model");
    lasso_body.setModel(utils.createModel(renderer, "eden:lasso_body", "lasso", null));
    lasso_body.anchor.set("rightArm");
    lasso_body.mirror = false;
    lasso_body.setScale(1.0);

    chest = renderer.createEffect("fiskheroes:chest");
    chest.setExtrude(1).setYOffset(1);

    var color = 0xFFFF55;

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(color);
    magic.colorEarthCrack.set(color);
    magic.colorAtmosphere.set(color);
    magic.colorWhip.set(color);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addFlightAnimation(renderer, "basic.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "basic.HOVER", "fiskheroes:flight/idle/propelled_hands");

    addAnimationWithData(renderer, "iron_man.LAND", "fiskheroes:superhero_landing", "fiskheroes:dyn/superhero_landing_timer")
        .priority = -8;

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

    addAnimationWithData(renderer, "wonder_woman.SWORD_POSE", "fiskheroes:sword_pose", "fiskheroes:shield_timer");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        lasso.opacity = entity.getData("fiskheroes:blade");
        lasso.render();

        var blade_anchor = lasso.anchor.set("rightArm");
        var blade_offSet = lasso.setOffset(1.8, 8.8, -2.6);
        var blade_rot = lasso.setRotation(90, 90, 0);
        lasso.anchor = blade_anchor, blade_offSet, blade_rot;

        lasso_body.opacity = entity.getData("fiskheroes:blade") < 1;
        lasso_body.render();

        var blade_anchor = lasso_body.anchor.set("body");
        var blade_offSet = lasso_body.setOffset(4.3, 9.8, -2.6);
        var blade_rot = lasso_body.setRotation(90, 90, 0);
        lasso_body.anchor = blade_anchor, blade_offSet, blade_rot;
    }
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        chest.render();
    }
       }


