extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:zeus_layer1",
    "layer2": "eden:zeus_layer2",
    "cape": "eden:zeus_cape",
    "zeus_thunder": "eden:zeus_thunder",
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var capes = implement("fiskheroes:external/capes");


function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    
    speedster.init(renderer, "fiskheroes:lightning_gold");

    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.maxFlare = 0.4;
    cape = capes.createDefault(renderer, 17, "fiskheroes:cape_default.mesh.json", physics);
    cape.effect.texture.set("cape");
    cape.effect.width = 12;

    zeus_thunder = renderer.createEffect("fiskheroes:overlay");
    zeus_thunder.texture.set(null, "zeus_thunder");

    // Antimatter Beam
    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:energy_projection", "body", 0xE0FFFF, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_energy_projection"));

    // Antimatter Blast
    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:lightning_cast", "rightArm", 0xE0FFFF, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
        { "firstPerson": [4.5, 3.75, -8.0], "offset": [0.5, 9.0, 0.0], "size": [3.0, 3.0], "anchor": "leftArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

    utils.bindBeam(renderer, "fiskheroes:lightning_cast", "fiskheroes:energy_discharge", "rightArm", 0xE0FFFF, [
        { "firstPerson": [-8.0, 4.5, -10.0], "offset": [-0.5, 9.0, 0.0], "size": [0.75, 0.75] }
    ]);	
    utils.bindBeam(renderer, "fiskheroes:energy_manipulation", "fiskheroes:energy_discharge", "rightArm", 0xE0FFFF, [
        { "firstPerson": [-2.5, 0.0, -7.0], "offset": [-0.5, 19.0, -12.0], "size": [1.5, 1.5] }
    ]);

    renderer.bindProperty("fiskheroes:energy_bolt").color.set(0xE0FFFF);
    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "body", "scale": 0.7, "offset": [-3.5, 2.0, 3.0], "rotation": [0.0, -90.0, 60.0] }
    ]).addOffset("QUIVER", 0.0, 0.0, 3.0);
}
function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");
    
	addAnimationWithData(renderer, "basic.AIMING", "fiskheroes:dual_aiming", "fiskheroes:beam_charge");
    utils.addFlightAnimation(renderer, "basic.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "basic.HOVER", "fiskheroes:flight/idle/propelled_hands");

    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        cape.render(entity);
    }
    if (renderLayer == "CHESTPLATE") {
        zeus_thunder.opacity = entity.getInterpolatedData("fiskheroes:energy_projection_timer");
        zeus_thunder.render();
    }
    if (renderLayer == "CHESTPLATE") {
        zeus_thunder.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        zeus_thunder.render();
    }
}