/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.common.ModDescriptionUpdatingHandler;
import com.aaronhowser1.dymm.common.configuration.MainConfigurationHandler;
import com.aaronhowser1.dymm.common.configuration.OldConfigurationMigrationTool;
import com.aaronhowser1.dymm.common.consume.ConsumerRegistry;
import com.aaronhowser1.dymm.common.consume.DocumentationConsumerDispatcher;
import com.aaronhowser1.dymm.common.loading.LoaderRegistry;
import com.aaronhowser1.dymm.common.loading.LoadingHandler;
import com.aaronhowser1.dymm.common.loading.TargetsHandler;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="dymm", name="Document Your Mod Mod", version="2.0.2", dependencies="required-after:jei@[1.12.2-4.15.0.268,)", guiFactory="com.aaronhowser1.dymm.client.ConfigurationGuiFactory", updateJSON="https://raw.githubusercontent.com/aaronhowser1/Document-Your-Mod-Mod/master/promo-slim.json", acceptedMinecraftVersions="[1.12.2]")
public final class DocumentYourMod {
    private static final L LOG = L.create("Document Your Mod Mod", "Lifecycle");
    private boolean trigger = false;

    @Mod.EventHandler
    public void onConstruct(@Nonnull FMLConstructionEvent event) {
    }

    @Mod.EventHandler
    public void onPreInitialization(@Nonnull FMLPreInitializationEvent event) {
        LOG.info("Loading main mod configurations");
        MainConfigurationHandler.initializeMainModConfiguration();
        LOG.info("Attempting to migrate old configuration data");
        OldConfigurationMigrationTool.attemptToMigrateConfiguration();
        LOG.info("Discovering and registering loaders");
        LoaderRegistry.INSTANCE.discoverLoadersFromClasspath();
    }

    @Mod.EventHandler
    public void onInitialization(@Nonnull FMLInitializationEvent event) {
        LOG.info("Discovering and registering consumers");
        ConsumerRegistry.INSTANCE.discoverConsumersFromClasspath();
    }

    @Mod.EventHandler
    public void onPostInitialization(@Nonnull FMLPostInitializationEvent event) {
        DocumentationConsumerDispatcher.dispatch();
        ModDescriptionUpdatingHandler.updateModDescription();
    }

    @Mod.EventHandler
    public void onLoadComplete(@Nonnull FMLLoadCompleteEvent event) {
        if (this.trigger) {
            return;
        }
        this.trigger = true;
        LOG.info("Reached loading completion: closing loading handlers and disabling future invocations");
        LoadingHandler.unbind();
        DocumentationConsumerDispatcher.unbind();
        TargetsHandler.discoverAndLog();
    }
}

