/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class JsonUtilities {
    private JsonUtilities() {
    }

    @Nonnull
    public static String asString(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return element.getAsJsonPrimitive().getAsString();
        }
        throw JsonUtilities.expectedType(element, name, "a string");
    }

    @Nonnull
    public static String getString(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asString(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "a string");
    }

    @Nonnull
    public static String getStringOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<String> fallback) {
        return object.has(name) ? JsonUtilities.getString(object, name) : fallback.get();
    }

    public static boolean asBoolean(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
            return element.getAsJsonPrimitive().getAsBoolean();
        }
        throw JsonUtilities.expectedType(element, name, "a boolean");
    }

    public static boolean getBoolean(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asBoolean(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "a boolean");
    }

    public static boolean getBooleanOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<Boolean> fallback) {
        return object.has(name) ? JsonUtilities.getBoolean(object, name) : fallback.get();
    }

    public static float asFloat(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return JsonUtilities.tryFloatNarrowing(JsonUtilities.asDouble(element, name));
        }
        throw JsonUtilities.expectedType(element, name, "a float");
    }

    public static float getFloat(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asFloat(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "a float");
    }

    public static float getFloatOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<Float> fallback) {
        return object.has(name) ? JsonUtilities.getFloat(object, name) : fallback.get().floatValue();
    }

    public static double asDouble(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsJsonPrimitive().getAsDouble();
        }
        throw JsonUtilities.expectedType(element, name, "a double");
    }

    public static double getDouble(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asDouble(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "a double");
    }

    public static double getDoubleOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<Double> fallback) {
        return object.has(name) ? JsonUtilities.getDouble(object, name) : fallback.get();
    }

    public static byte asByte(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return JsonUtilities.tryByteNarrowing(JsonUtilities.asLong(element, name));
        }
        throw JsonUtilities.expectedType(element, name, "a short");
    }

    public static byte getByte(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asByte(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "an integer");
    }

    public static byte getByteOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<Byte> fallback) {
        return object.has(name) ? JsonUtilities.getByte(object, name) : fallback.get();
    }

    public static short asShort(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return JsonUtilities.tryShortNarrowing(JsonUtilities.asLong(element, name));
        }
        throw JsonUtilities.expectedType(element, name, "a short");
    }

    public static short getShort(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asShort(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "an integer");
    }

    public static short getShortOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<Short> fallback) {
        return object.has(name) ? JsonUtilities.getShort(object, name) : fallback.get();
    }

    public static int asInt(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return JsonUtilities.tryIntNarrowing(JsonUtilities.asLong(element, name));
        }
        throw JsonUtilities.expectedType(element, name, "an integer");
    }

    public static int getInt(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asInt(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "an integer");
    }

    public static int getIntOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<Integer> fallback) {
        return object.has(name) ? JsonUtilities.getInt(object, name) : fallback.get();
    }

    public static long asLong(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsJsonPrimitive().getAsLong();
        }
        throw JsonUtilities.expectedType(element, name, "a long");
    }

    public static long getLong(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asLong(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "a long");
    }

    public static long getLongOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<Long> fallback) {
        return object.has(name) ? JsonUtilities.getLong(object, name) : fallback.get();
    }

    @Nonnull
    public static JsonObject asJsonObject(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject();
        }
        throw JsonUtilities.expectedType(element, name, "an object");
    }

    @Nonnull
    public static JsonObject getJsonObject(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asJsonObject(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "an object");
    }

    @Nonnull
    public static JsonObject getJsonObjectOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<JsonObject> fallback) {
        return object.has(name) ? JsonUtilities.getJsonObject(object, name) : fallback.get();
    }

    @Nonnull
    public static JsonArray asJsonArray(@Nonnull JsonElement element, @Nonnull String name) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        throw JsonUtilities.expectedType(element, name, "an array");
    }

    @Nonnull
    public static JsonArray getJsonArray(@Nonnull JsonObject object, @Nonnull String name) {
        if (object.has(name)) {
            return JsonUtilities.asJsonArray(object.get(name), name);
        }
        throw JsonUtilities.missingProperty(name, "an array");
    }

    @Nonnull
    public static JsonArray getJsonArrayOrElse(@Nonnull JsonObject object, @Nonnull String name, @Nonnull Supplier<JsonArray> fallback) {
        return object.has(name) ? JsonUtilities.getJsonArray(object, name) : fallback.get();
    }

    public static boolean checkEntriesAsJsonObjects(@Nonnull JsonArray array, @Nonnull String name, @Nonnull Predicate<JsonObject> matcher) {
        for (int i = 0; i < array.size(); ++i) {
            if (matcher.test(JsonUtilities.asJsonObject(array.get(i), name + "[" + i + "]"))) continue;
            return false;
        }
        return true;
    }

    public static void consumeEntriesAsJsonObjects(@Nonnull JsonArray array, @Nonnull String name, @Nonnull Consumer<JsonObject> consumer) {
        for (int i = 0; i < array.size(); ++i) {
            consumer.accept(JsonUtilities.asJsonObject(array.get(i), name + "[" + i + "]"));
        }
    }

    private static byte tryByteNarrowing(long value) {
        if (value >= 127L || value < -128L) {
            throw JsonUtilities.narrowingFailed(value, "a byte");
        }
        return (byte)value;
    }

    private static short tryShortNarrowing(long value) {
        if (value >= 32767L || value < -32768L) {
            throw JsonUtilities.narrowingFailed(value, "a short");
        }
        return (short)value;
    }

    private static int tryIntNarrowing(long value) {
        if (value >= Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw JsonUtilities.narrowingFailed(value, "an integer");
        }
        return (int)value;
    }

    private static float tryFloatNarrowing(double value) {
        if (value >= 3.4028234663852886E38 || value < -3.4028234663852886E38) {
            throw JsonUtilities.narrowingFailed(value, "a float");
        }
        return (float)value;
    }

    @Nonnull
    private static JsonSyntaxException expectedType(@Nonnull JsonElement element, @Nonnull String name, @Nonnull String expected) {
        throw new JsonSyntaxException("Expected '" + name + "' to be " + expected + ", but it was " + JsonUtilities.toErrorString(element));
    }

    @Nonnull
    private static JsonSyntaxException missingProperty(@Nonnull String name, @Nonnull String expected) {
        throw new JsonSyntaxException("Property '" + name + "' was missing: expected to find " + expected);
    }

    @Nonnull
    private static <T extends Number> JsonSyntaxException narrowingFailed(@Nonnull T value, @Nonnull String name) {
        throw new JsonSyntaxException("Number '" + value + "' is too big to be represented as " + name);
    }

    @Nonnull
    private static String toErrorString(@Nonnull JsonElement element) {
        String content = StringUtils.abbreviateMiddle((String)element.toString(), (String)"...", (int)10);
        if (element.isJsonNull()) {
            return "null";
        }
        if (element.isJsonArray()) {
            return "an array (" + content + ")";
        }
        if (element.isJsonObject()) {
            return "an object (" + content + ")";
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return "a string (" + content + ")";
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
            return "a boolean (" + content + ")";
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return "a number (" + content + ")";
        }
        throw new IllegalStateException("Given element " + element + " is not a valid JSON element");
    }
}

