/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.Supplier;

public final class L
implements Logger {
    private final Logger logger;

    private L(@Nonnull String id, @Nonnull String marker) {
        this.logger = LogManager.getLogger((String)(id + (marker.trim().isEmpty() ? "" : "/" + marker)));
    }

    @Nonnull
    public static L create(@Nonnull String id) {
        return L.create(id, "");
    }

    @Nonnull
    public static L create(@Nonnull String id, @Nonnull String marker) {
        return new L((String)Preconditions.checkNotNull((Object)id), (String)Preconditions.checkNotNull((Object)marker));
    }

    public void logAndDump(@Nonnull String message) {
        this.logAndDump(message, DumpStackBehavior.FULL_DUMP);
    }

    public void logAndDump(@Nonnull String message, @Nonnull DumpStackBehavior behavior) {
        this.doBigMessage(message, behavior, this::info);
    }

    public void bigWarn(@Nonnull String message) {
        this.bigWarn(message, DumpStackBehavior.NORMAL_DUMP);
    }

    public void bigWarn(@Nonnull String message, @Nonnull DumpStackBehavior behavior) {
        this.doBigMessage(message, behavior, this::warn);
    }

    public void bigError(@Nonnull String message) {
        this.bigError(message, DumpStackBehavior.NORMAL_DUMP);
    }

    public void bigError(@Nonnull String message, @Nonnull DumpStackBehavior behavior) {
        this.doBigMessage(message, behavior, this::error);
    }

    private void doBigMessage(@Nonnull String message, @Nonnull DumpStackBehavior dsb, @Nonnull Consumer<String> logFun) {
        StringBuilder messageBuilder = new StringBuilder();
        List<String> lines = L.lines(L.replaceAllTabs(L.injectStartAndStopNewLine(L.addDumpIfNeeded(message, dsb))));
        int maxLineLength = lines.stream().mapToInt(String::length).max().orElse(0);
        int maxLength = maxLineLength + 4;
        IntStream.range(0, maxLength).forEach(i -> messageBuilder.append('*'));
        messageBuilder.append('\n');
        lines.forEach(it -> {
            messageBuilder.append("* ");
            messageBuilder.append((String)it);
            IntStream.range(0, -(it.length() - maxLineLength)).forEach(i -> messageBuilder.append(' '));
            messageBuilder.append(" *\n");
        });
        IntStream.range(0, maxLength).forEach(i -> messageBuilder.append('*'));
        List<String> logLines = Arrays.asList(messageBuilder.toString().replace("\r", "").replace("\t", "    ").split(Pattern.quote("\n")));
        messageBuilder.delete(0, messageBuilder.length());
        logLines.forEach(logFun);
    }

    @Nonnull
    private static String injectStartAndStopNewLine(@Nonnull String message) {
        return String.format(" \n%s\n ", message);
    }

    @Nonnull
    private static String replaceAllTabs(@Nonnull String message) {
        return message.replace("\t", "    ");
    }

    @Nonnull
    private static List<String> lines(@Nonnull String message) {
        return Arrays.asList(message.split(Pattern.quote("\n")));
    }

    @Nonnull
    private static String addDumpIfNeeded(@Nonnull String message, @Nonnull DumpStackBehavior dsb) {
        return dsb == DumpStackBehavior.DO_NOT_DUMP ? message : L.doDump(message, dsb);
    }

    @Nonnull
    private static String doDump(@Nonnull String initialString, @Nonnull DumpStackBehavior dsb) {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StringBuilder builder = new StringBuilder();
        builder.append(initialString);
        builder.append("\n\n");
        int start = dsb == DumpStackBehavior.FULL_DUMP ? 0 : 4;
        int endT = dsb == DumpStackBehavior.NORMAL_DUMP ? Math.min(stack.length, 4) : stack.length;
        int end = Math.min(start + endT, stack.length);
        IntStream.range(start, end).forEach(i -> {
            builder.append(L.toPrintableString(stack[i]));
            if (i != end - 1) {
                builder.append('\n');
            }
        });
        if (dsb == DumpStackBehavior.NORMAL_DUMP) {
            builder.append("\n... (Rest of stack dump omitted)");
        }
        return builder.toString();
    }

    @Nonnull
    private static String toPrintableString(@Nonnull StackTraceElement element) {
        if (element.isNativeMethod()) {
            return String.format("at %s.%s (in JNI)", element.getClassName(), element.getMethodName());
        }
        return String.format("at %s.%s (%s:%s)", element.getClassName(), element.getMethodName(), element.getFileName() != null ? element.getFileName() : "???", element.getLineNumber() < 0 ? "???" : "" + element.getLineNumber());
    }

    public void catching(@Nonnull Level level, @Nonnull Throwable t) {
        this.logger.catching(level, t);
    }

    public void catching(@Nonnull Throwable t) {
        this.logger.catching(t);
    }

    public void debug(@Nonnull Marker marker, @Nonnull Message msg) {
        this.logger.debug(marker, msg);
    }

    public void debug(@Nonnull Marker marker, @Nonnull Message msg, @Nullable Throwable t) {
        this.logger.debug(marker, msg, t);
    }

    public void debug(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier) {
        this.logger.debug(marker, msgSupplier);
    }

    public void debug(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier, @Nullable Throwable t) {
        this.logger.debug(marker, msgSupplier, t);
    }

    public void debug(@Nonnull Marker marker, @Nonnull CharSequence message) {
        this.logger.debug(marker, message);
    }

    public void debug(@Nonnull Marker marker, @Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.debug(marker, message, t);
    }

    public void debug(@Nonnull Marker marker, @Nonnull Object message) {
        this.logger.debug(marker, message);
    }

    public void debug(@Nonnull Marker marker, @Nonnull Object message, @Nonnull Throwable t) {
        this.logger.debug(marker, message, t);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message) {
        this.logger.debug(marker, message);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, Object ... params) {
        this.logger.debug(marker, message, params);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.debug(marker, message, paramSuppliers);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nonnull Throwable t) {
        this.logger.debug(marker, message, t);
    }

    public void debug(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier) {
        this.logger.debug(marker, msgSupplier);
    }

    public void debug(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier, @Nullable Throwable t) {
        this.logger.debug(marker, msgSupplier, t);
    }

    public void debug(@Nonnull Message msg) {
        this.logger.debug(msg);
    }

    public void debug(@Nonnull Message msg, @Nullable Throwable t) {
        this.logger.debug(msg, t);
    }

    public void debug(@Nonnull MessageSupplier msgSupplier) {
        this.logger.debug(msgSupplier);
    }

    public void debug(@Nonnull MessageSupplier msgSupplier, @Nonnull Throwable t) {
        this.logger.debug(msgSupplier, t);
    }

    public void debug(@Nonnull CharSequence message) {
        this.logger.debug(message);
    }

    public void debug(@Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.debug(message, t);
    }

    public void debug(@Nonnull Object message) {
        this.logger.debug(message);
    }

    public void debug(@Nonnull Object message, @Nonnull Throwable t) {
        this.logger.debug(message, t);
    }

    public void debug(@Nonnull String message) {
        this.logger.debug(message);
    }

    public void debug(@Nonnull String message, Object ... params) {
        this.logger.debug(message, params);
    }

    public void debug(@Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.debug(message, paramSuppliers);
    }

    public void debug(@Nonnull String message, @Nonnull Throwable t) {
        this.logger.debug(message, t);
    }

    public void debug(@Nonnull Supplier<?> msgSupplier) {
        this.logger.debug(msgSupplier);
    }

    public void debug(@Nonnull Supplier<?> msgSupplier, @Nonnull Throwable t) {
        this.logger.debug(msgSupplier, t);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0) {
        this.logger.debug(marker, message, p0);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.debug(marker, message, p0, p1);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.debug(marker, message, p0, p1, p2);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.debug(marker, message, p0, p1, p2, p3);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.debug(marker, message, p0, p1, p2, p3, p4);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.debug(marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.debug(marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.debug(marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.debug(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void debug(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.debug(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void debug(@Nonnull String message, @Nullable Object p0) {
        this.logger.debug(message, p0);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.debug(message, p0, p1);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.debug(message, p0, p1, p2);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.debug(message, p0, p1, p2, p3);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.debug(message, p0, p1, p2, p3, p4);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.debug(message, p0, p1, p2, p3, p4, p5);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.debug(message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.debug(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.debug(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void debug(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.debug(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Deprecated
    public void entry() {
        this.logger.entry();
    }

    public void entry(Object ... params) {
        this.logger.entry(params);
    }

    public void error(@Nonnull Marker marker, @Nonnull Message msg) {
        this.logger.error(marker, msg);
    }

    public void error(@Nonnull Marker marker, @Nonnull Message msg, @Nullable Throwable t) {
        this.logger.error(marker, msg, t);
    }

    public void error(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier) {
        this.logger.error(marker, msgSupplier);
    }

    public void error(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier, @Nullable Throwable t) {
        this.logger.error(marker, msgSupplier, t);
    }

    public void error(@Nonnull Marker marker, @Nonnull CharSequence message) {
        this.logger.error(marker, message);
    }

    public void error(@Nonnull Marker marker, @Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.error(marker, message, t);
    }

    public void error(@Nonnull Marker marker, @Nonnull Object message) {
        this.logger.error(marker, message);
    }

    public void error(@Nonnull Marker marker, @Nonnull Object message, @Nonnull Throwable t) {
        this.logger.error(marker, message, t);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message) {
        this.logger.error(marker, message);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, Object ... params) {
        this.logger.error(marker, message, params);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.error(marker, message, paramSuppliers);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nonnull Throwable t) {
        this.logger.error(marker, message, t);
    }

    public void error(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier) {
        this.logger.error(marker, msgSupplier);
    }

    public void error(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier, @Nullable Throwable t) {
        this.logger.error(marker, msgSupplier, t);
    }

    public void error(@Nonnull Message msg) {
        this.logger.error(msg);
    }

    public void error(@Nonnull Message msg, @Nullable Throwable t) {
        this.logger.error(msg, t);
    }

    public void error(@Nonnull MessageSupplier msgSupplier) {
        this.logger.error(msgSupplier);
    }

    public void error(@Nonnull MessageSupplier msgSupplier, @Nonnull Throwable t) {
        this.logger.error(msgSupplier, t);
    }

    public void error(@Nonnull CharSequence message) {
        this.logger.error(message);
    }

    public void error(@Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.error(message, t);
    }

    public void error(@Nonnull Object message) {
        this.logger.error(message);
    }

    public void error(@Nonnull Object message, @Nonnull Throwable t) {
        this.logger.error(message, t);
    }

    public void error(@Nonnull String message) {
        this.logger.error(message);
    }

    public void error(@Nonnull String message, Object ... params) {
        this.logger.error(message, params);
    }

    public void error(@Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.error(message, paramSuppliers);
    }

    public void error(@Nonnull String message, @Nonnull Throwable t) {
        this.logger.error(message, t);
    }

    public void error(@Nonnull Supplier<?> msgSupplier) {
        this.logger.error(msgSupplier);
    }

    public void error(@Nonnull Supplier<?> msgSupplier, @Nonnull Throwable t) {
        this.logger.error(msgSupplier, t);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0) {
        this.logger.error(marker, message, p0);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.error(marker, message, p0, p1);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.error(marker, message, p0, p1, p2);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.error(marker, message, p0, p1, p2, p3);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.error(marker, message, p0, p1, p2, p3, p4);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.error(marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.error(marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.error(marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.error(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void error(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.error(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void error(@Nonnull String message, @Nullable Object p0) {
        this.logger.error(message, p0);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.error(message, p0, p1);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.error(message, p0, p1, p2);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.error(message, p0, p1, p2, p3);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.error(message, p0, p1, p2, p3, p4);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.error(message, p0, p1, p2, p3, p4, p5);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.error(message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.error(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.error(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void error(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.error(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Deprecated
    public void exit() {
        this.logger.exit();
    }

    @Deprecated
    @Nullable
    public <R> R exit(@Nullable R result) {
        return (R)this.logger.exit(result);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull Message msg) {
        this.logger.fatal(marker, msg);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull Message msg, @Nullable Throwable t) {
        this.logger.fatal(marker, msg, t);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier) {
        this.logger.fatal(marker, msgSupplier);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier, @Nullable Throwable t) {
        this.logger.fatal(marker, msgSupplier, t);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull CharSequence message) {
        this.logger.fatal(marker, message);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.fatal(marker, message, t);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull Object message) {
        this.logger.fatal(marker, message);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull Object message, @Nonnull Throwable t) {
        this.logger.fatal(marker, message, t);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message) {
        this.logger.fatal(marker, message);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, Object ... params) {
        this.logger.fatal(marker, message, params);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.fatal(marker, message, paramSuppliers);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nonnull Throwable t) {
        this.logger.fatal(marker, message, t);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier) {
        this.logger.fatal(marker, msgSupplier);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier, @Nullable Throwable t) {
        this.logger.fatal(marker, msgSupplier, t);
    }

    public void fatal(@Nonnull Message msg) {
        this.logger.fatal(msg);
    }

    public void fatal(@Nonnull Message msg, @Nullable Throwable t) {
        this.logger.fatal(msg, t);
    }

    public void fatal(@Nonnull MessageSupplier msgSupplier) {
        this.logger.fatal(msgSupplier);
    }

    public void fatal(@Nonnull MessageSupplier msgSupplier, @Nonnull Throwable t) {
        this.logger.fatal(msgSupplier, t);
    }

    public void fatal(@Nonnull CharSequence message) {
        this.logger.fatal(message);
    }

    public void fatal(@Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.fatal(message, t);
    }

    public void fatal(@Nonnull Object message) {
        this.logger.fatal(message);
    }

    public void fatal(@Nonnull Object message, @Nonnull Throwable t) {
        this.logger.fatal(message, t);
    }

    public void fatal(@Nonnull String message) {
        this.logger.fatal(message);
    }

    public void fatal(@Nonnull String message, Object ... params) {
        this.logger.fatal(message, params);
    }

    public void fatal(@Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.fatal(message, paramSuppliers);
    }

    public void fatal(@Nonnull String message, @Nonnull Throwable t) {
        this.logger.fatal(message, t);
    }

    public void fatal(@Nonnull Supplier<?> msgSupplier) {
        this.logger.fatal(msgSupplier);
    }

    public void fatal(@Nonnull Supplier<?> msgSupplier, @Nonnull Throwable t) {
        this.logger.fatal(msgSupplier, t);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0) {
        this.logger.fatal(marker, message, p0);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.fatal(marker, message, p0, p1);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.fatal(marker, message, p0, p1, p2);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.fatal(marker, message, p0, p1, p2, p3);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.fatal(marker, message, p0, p1, p2, p3, p4);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.fatal(marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.fatal(marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.fatal(marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.fatal(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void fatal(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.fatal(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0) {
        this.logger.fatal(message, p0);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.fatal(message, p0, p1);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.fatal(message, p0, p1, p2);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.fatal(message, p0, p1, p2, p3);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.fatal(message, p0, p1, p2, p3, p4);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.fatal(message, p0, p1, p2, p3, p4, p5);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.fatal(message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.fatal(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.fatal(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void fatal(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.fatal(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Nonnull
    public Level getLevel() {
        return this.logger.getLevel();
    }

    @Nonnull
    public <MF extends MessageFactory> MF getMessageFactory() {
        return (MF)this.logger.getMessageFactory();
    }

    @Nonnull
    public String getName() {
        return this.logger.getName();
    }

    public void info(@Nonnull Marker marker, @Nonnull Message msg) {
        this.logger.info(marker, msg);
    }

    public void info(@Nonnull Marker marker, @Nonnull Message msg, @Nullable Throwable t) {
        this.logger.info(marker, msg, t);
    }

    public void info(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier) {
        this.logger.info(marker, msgSupplier);
    }

    public void info(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier, @Nullable Throwable t) {
        this.logger.info(marker, msgSupplier, t);
    }

    public void info(@Nonnull Marker marker, @Nonnull CharSequence message) {
        this.logger.info(marker, message);
    }

    public void info(@Nonnull Marker marker, @Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.info(marker, message, t);
    }

    public void info(@Nonnull Marker marker, @Nonnull Object message) {
        this.logger.info(marker, message);
    }

    public void info(@Nonnull Marker marker, @Nonnull Object message, @Nonnull Throwable t) {
        this.logger.info(marker, message, t);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message) {
        this.logger.info(marker, message);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, Object ... params) {
        this.logger.info(marker, message, params);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.info(marker, message, paramSuppliers);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nonnull Throwable t) {
        this.logger.info(marker, message, t);
    }

    public void info(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier) {
        this.logger.info(marker, msgSupplier);
    }

    public void info(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier, @Nullable Throwable t) {
        this.logger.info(marker, msgSupplier, t);
    }

    public void info(@Nonnull Message msg) {
        this.logger.info(msg);
    }

    public void info(@Nonnull Message msg, @Nullable Throwable t) {
        this.logger.info(msg, t);
    }

    public void info(@Nonnull MessageSupplier msgSupplier) {
        this.logger.info(msgSupplier);
    }

    public void info(@Nonnull MessageSupplier msgSupplier, @Nonnull Throwable t) {
        this.logger.info(msgSupplier, t);
    }

    public void info(@Nonnull CharSequence message) {
        this.logger.info(message);
    }

    public void info(@Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.info(message, t);
    }

    public void info(@Nonnull Object message) {
        this.logger.info(message);
    }

    public void info(@Nonnull Object message, @Nonnull Throwable t) {
        this.logger.info(message, t);
    }

    public void info(@Nonnull String message) {
        this.logger.info(message);
    }

    public void info(@Nonnull String message, Object ... params) {
        this.logger.info(message, params);
    }

    public void info(@Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.info(message, paramSuppliers);
    }

    public void info(@Nonnull String message, @Nonnull Throwable t) {
        this.logger.info(message, t);
    }

    public void info(@Nonnull Supplier<?> msgSupplier) {
        this.logger.info(msgSupplier);
    }

    public void info(@Nonnull Supplier<?> msgSupplier, @Nonnull Throwable t) {
        this.logger.info(msgSupplier, t);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0) {
        this.logger.info(marker, message, p0);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.info(marker, message, p0, p1);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.info(marker, message, p0, p1, p2);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.info(marker, message, p0, p1, p2, p3);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.info(marker, message, p0, p1, p2, p3, p4);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.info(marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.info(marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.info(marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.info(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void info(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.info(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void info(@Nonnull String message, @Nullable Object p0) {
        this.logger.info(message, p0);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.info(message, p0, p1);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.info(message, p0, p1, p2);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.info(message, p0, p1, p2, p3);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.info(message, p0, p1, p2, p3, p4);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.info(message, p0, p1, p2, p3, p4, p5);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.info(message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.info(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.info(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void info(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.info(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isDebugEnabled(@Nonnull Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public boolean isEnabled(@Nonnull Level level) {
        return this.logger.isEnabled(level);
    }

    public boolean isEnabled(@Nonnull Level level, @Nonnull Marker marker) {
        return this.logger.isEnabled(level, marker);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isErrorEnabled(@Nonnull Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    public boolean isFatalEnabled(@Nonnull Marker marker) {
        return this.logger.isFatalEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isInfoEnabled(@Nonnull Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isTraceEnabled(@Nonnull Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isWarnEnabled(@Nonnull Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull Message msg) {
        this.logger.log(level, marker, msg);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull Message msg, @Nullable Throwable t) {
        this.logger.log(level, marker, msg, t);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier) {
        this.logger.log(level, marker, msgSupplier);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier, @Nullable Throwable t) {
        this.logger.log(level, marker, msgSupplier, t);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull CharSequence message) {
        this.logger.log(level, marker, message);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.log(level, marker, message, t);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull Object message) {
        this.logger.log(level, marker, message);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull Object message, @Nonnull Throwable t) {
        this.logger.log(level, marker, message, t);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message) {
        this.logger.log(level, marker, message);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, Object ... params) {
        this.logger.log(level, marker, message, params);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.log(level, marker, message, paramSuppliers);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nonnull Throwable t) {
        this.logger.log(level, marker, message, t);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier) {
        this.logger.log(level, marker, msgSupplier);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier, @Nullable Throwable t) {
        this.logger.log(level, marker, msgSupplier, t);
    }

    public void log(@Nonnull Level level, @Nonnull Message msg) {
        this.logger.log(level, msg);
    }

    public void log(@Nonnull Level level, @Nonnull Message msg, @Nullable Throwable t) {
        this.logger.log(level, msg, t);
    }

    public void log(@Nonnull Level level, @Nonnull MessageSupplier msgSupplier) {
        this.logger.log(level, msgSupplier);
    }

    public void log(@Nonnull Level level, @Nonnull MessageSupplier msgSupplier, @Nonnull Throwable t) {
        this.logger.log(level, msgSupplier, t);
    }

    public void log(@Nonnull Level level, @Nonnull CharSequence message) {
        this.logger.log(level, message);
    }

    public void log(@Nonnull Level level, @Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.log(level, message, t);
    }

    public void log(@Nonnull Level level, @Nonnull Object message) {
        this.logger.log(level, message);
    }

    public void log(@Nonnull Level level, @Nonnull Object message, @Nonnull Throwable t) {
        this.logger.log(level, message, t);
    }

    public void log(@Nonnull Level level, @Nonnull String message) {
        this.logger.log(level, message);
    }

    public void log(@Nonnull Level level, @Nonnull String message, Object ... params) {
        this.logger.log(level, message, params);
    }

    public void log(@Nonnull Level level, @Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.log(level, message, paramSuppliers);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nonnull Throwable t) {
        this.logger.log(level, message, t);
    }

    public void log(@Nonnull Level level, @Nonnull Supplier<?> msgSupplier) {
        this.logger.log(level, msgSupplier);
    }

    public void log(@Nonnull Level level, @Nonnull Supplier<?> msgSupplier, @Nonnull Throwable t) {
        this.logger.log(level, msgSupplier, t);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0) {
        this.logger.log(level, marker, message, p0);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.log(level, marker, message, p0, p1);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.log(level, marker, message, p0, p1, p2);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.log(level, marker, message, p0, p1, p2, p3);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.log(level, marker, message, p0, p1, p2, p3, p4);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.log(level, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.log(level, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.log(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.log(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void log(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.log(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0) {
        this.logger.log(level, message, p0);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.log(level, message, p0, p1);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.log(level, message, p0, p1, p2);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.log(level, message, p0, p1, p2, p3);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.log(level, message, p0, p1, p2, p3, p4);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.log(level, message, p0, p1, p2, p3, p4, p5);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.log(level, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.log(level, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.log(level, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void log(@Nonnull Level level, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.log(level, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void printf(@Nonnull Level level, @Nonnull Marker marker, @Nonnull String format, Object ... params) {
        this.logger.printf(level, marker, format, params);
    }

    public void printf(@Nonnull Level level, @Nonnull String format, Object ... params) {
        this.logger.printf(level, format, params);
    }

    @Nonnull
    public <T extends Throwable> T throwing(@Nonnull Level level, @Nonnull T t) {
        return (T)this.logger.throwing(level, t);
    }

    @Nonnull
    public <T extends Throwable> T throwing(@Nonnull T t) {
        return (T)this.logger.throwing(t);
    }

    public void trace(@Nonnull Marker marker, @Nonnull Message msg) {
        this.logger.trace(marker, msg);
    }

    public void trace(@Nonnull Marker marker, @Nonnull Message msg, @Nullable Throwable t) {
        this.logger.trace(marker, msg, t);
    }

    public void trace(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier) {
        this.logger.trace(marker, msgSupplier);
    }

    public void trace(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier, @Nullable Throwable t) {
        this.logger.trace(marker, msgSupplier, t);
    }

    public void trace(@Nonnull Marker marker, @Nonnull CharSequence message) {
        this.logger.trace(marker, message);
    }

    public void trace(@Nonnull Marker marker, @Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.trace(marker, message, t);
    }

    public void trace(@Nonnull Marker marker, @Nonnull Object message) {
        this.logger.trace(marker, message);
    }

    public void trace(@Nonnull Marker marker, @Nonnull Object message, @Nonnull Throwable t) {
        this.logger.trace(marker, message, t);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message) {
        this.logger.trace(marker, message);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, Object ... params) {
        this.logger.trace(marker, message, params);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.trace(marker, message, paramSuppliers);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nonnull Throwable t) {
        this.logger.trace(marker, message, t);
    }

    public void trace(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier) {
        this.logger.trace(marker, msgSupplier);
    }

    public void trace(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier, @Nullable Throwable t) {
        this.logger.trace(marker, msgSupplier, t);
    }

    public void trace(@Nonnull Message msg) {
        this.logger.trace(msg);
    }

    public void trace(@Nonnull Message msg, @Nullable Throwable t) {
        this.logger.trace(msg, t);
    }

    public void trace(@Nonnull MessageSupplier msgSupplier) {
        this.logger.trace(msgSupplier);
    }

    public void trace(@Nonnull MessageSupplier msgSupplier, @Nonnull Throwable t) {
        this.logger.trace(msgSupplier, t);
    }

    public void trace(@Nonnull CharSequence message) {
        this.logger.trace(message);
    }

    public void trace(@Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.trace(message, t);
    }

    public void trace(@Nonnull Object message) {
        this.logger.trace(message);
    }

    public void trace(@Nonnull Object message, @Nonnull Throwable t) {
        this.logger.trace(message, t);
    }

    public void trace(@Nonnull String message) {
        this.logger.trace(message);
    }

    public void trace(@Nonnull String message, Object ... params) {
        this.logger.trace(message, params);
    }

    public void trace(@Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.trace(message, paramSuppliers);
    }

    public void trace(@Nonnull String message, @Nonnull Throwable t) {
        this.logger.trace(message, t);
    }

    public void trace(@Nonnull Supplier<?> msgSupplier) {
        this.logger.trace(msgSupplier);
    }

    public void trace(@Nonnull Supplier<?> msgSupplier, @Nonnull Throwable t) {
        this.logger.trace(msgSupplier, t);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0) {
        this.logger.trace(marker, message, p0);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.trace(marker, message, p0, p1);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.trace(marker, message, p0, p1, p2);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.trace(marker, message, p0, p1, p2, p3);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.trace(marker, message, p0, p1, p2, p3, p4);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.trace(marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.trace(marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.trace(marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.trace(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void trace(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.trace(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void trace(@Nonnull String message, @Nullable Object p0) {
        this.logger.trace(message, p0);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.trace(message, p0, p1);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.trace(message, p0, p1, p2);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.trace(message, p0, p1, p2, p3);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.trace(message, p0, p1, p2, p3, p4);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.trace(message, p0, p1, p2, p3, p4, p5);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.trace(message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.trace(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.trace(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void trace(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.trace(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Nonnull
    public EntryMessage traceEntry() {
        return this.logger.traceEntry();
    }

    @Nonnull
    public EntryMessage traceEntry(@Nonnull String format, Object ... params) {
        return this.logger.traceEntry(format, params);
    }

    @Nonnull
    public EntryMessage traceEntry(Supplier<?> ... paramSuppliers) {
        return this.logger.traceEntry(paramSuppliers);
    }

    public EntryMessage traceEntry(@Nonnull String format, Supplier<?> ... paramSuppliers) {
        return this.logger.traceEntry(format, paramSuppliers);
    }

    @Nonnull
    public EntryMessage traceEntry(@Nonnull Message message) {
        return this.logger.traceEntry(message);
    }

    public void traceExit() {
        this.logger.traceExit();
    }

    @Nullable
    public <R> R traceExit(@Nullable R result) {
        return (R)this.logger.traceExit(result);
    }

    @Nullable
    public <R> R traceExit(@Nonnull String format, @Nullable R result) {
        return (R)this.logger.traceExit(format, result);
    }

    public void traceExit(@Nonnull EntryMessage message) {
        this.logger.traceExit(message);
    }

    @Nullable
    public <R> R traceExit(@Nonnull EntryMessage message, @Nullable R result) {
        return (R)this.logger.traceExit(message, result);
    }

    @Nullable
    public <R> R traceExit(@Nonnull Message message, @Nullable R result) {
        return (R)this.logger.traceExit(message, result);
    }

    public void warn(@Nonnull Marker marker, @Nonnull Message msg) {
        this.logger.warn(marker, msg);
    }

    public void warn(@Nonnull Marker marker, @Nonnull Message msg, @Nullable Throwable t) {
        this.logger.warn(marker, msg, t);
    }

    public void warn(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier) {
        this.logger.warn(marker, msgSupplier);
    }

    public void warn(@Nonnull Marker marker, @Nonnull MessageSupplier msgSupplier, @Nullable Throwable t) {
        this.logger.warn(marker, msgSupplier, t);
    }

    public void warn(@Nonnull Marker marker, @Nonnull CharSequence message) {
        this.logger.warn(marker, message);
    }

    public void warn(@Nonnull Marker marker, @Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.warn(marker, message, t);
    }

    public void warn(@Nonnull Marker marker, @Nonnull Object message) {
        this.logger.warn(marker, message);
    }

    public void warn(@Nonnull Marker marker, @Nonnull Object message, @Nonnull Throwable t) {
        this.logger.warn(marker, message, t);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message) {
        this.logger.warn(marker, message);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, Object ... params) {
        this.logger.warn(marker, message, params);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.warn(marker, message, paramSuppliers);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nonnull Throwable t) {
        this.logger.warn(marker, message, t);
    }

    public void warn(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier) {
        this.logger.warn(marker, msgSupplier);
    }

    public void warn(@Nonnull Marker marker, @Nonnull Supplier<?> msgSupplier, @Nullable Throwable t) {
        this.logger.warn(marker, msgSupplier, t);
    }

    public void warn(@Nonnull Message msg) {
        this.logger.warn(msg);
    }

    public void warn(@Nonnull Message msg, @Nullable Throwable t) {
        this.logger.warn(msg, t);
    }

    public void warn(@Nonnull MessageSupplier msgSupplier) {
        this.logger.warn(msgSupplier);
    }

    public void warn(@Nonnull MessageSupplier msgSupplier, @Nonnull Throwable t) {
        this.logger.warn(msgSupplier, t);
    }

    public void warn(@Nonnull CharSequence message) {
        this.logger.warn(message);
    }

    public void warn(@Nonnull CharSequence message, @Nonnull Throwable t) {
        this.logger.warn(message, t);
    }

    public void warn(@Nonnull Object message) {
        this.logger.warn(message);
    }

    public void warn(@Nonnull Object message, @Nonnull Throwable t) {
        this.logger.warn(message, t);
    }

    public void warn(@Nonnull String message) {
        this.logger.warn(message);
    }

    public void warn(@Nonnull String message, Object ... params) {
        this.logger.warn(message, params);
    }

    public void warn(@Nonnull String message, Supplier<?> ... paramSuppliers) {
        this.logger.warn(message, paramSuppliers);
    }

    public void warn(@Nonnull String message, @Nonnull Throwable t) {
        this.logger.warn(message, t);
    }

    public void warn(@Nonnull Supplier<?> msgSupplier) {
        this.logger.warn(msgSupplier);
    }

    public void warn(@Nonnull Supplier<?> msgSupplier, @Nonnull Throwable t) {
        this.logger.warn(msgSupplier, t);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0) {
        this.logger.warn(marker, message, p0);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.warn(marker, message, p0, p1);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.warn(marker, message, p0, p1, p2);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.warn(marker, message, p0, p1, p2, p3);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.warn(marker, message, p0, p1, p2, p3, p4);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.warn(marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.warn(marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.warn(marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.warn(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void warn(@Nonnull Marker marker, @Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.warn(marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void warn(@Nonnull String message, @Nullable Object p0) {
        this.logger.warn(message, p0);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1) {
        this.logger.warn(message, p0, p1);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2) {
        this.logger.warn(message, p0, p1, p2);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        this.logger.warn(message, p0, p1, p2, p3);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        this.logger.warn(message, p0, p1, p2, p3, p4);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        this.logger.warn(message, p0, p1, p2, p3, p4, p5);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        this.logger.warn(message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        this.logger.warn(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        this.logger.warn(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void warn(@Nonnull String message, @Nullable Object p0, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        this.logger.warn(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public static enum DumpStackBehavior {
        FULL_DUMP,
        NORMAL_DUMP,
        DO_NOT_DUMP;

    }
}

