/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.client;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.configuration.ConfigurationManager;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class ConfigurationGuiFactory
implements IModGuiFactory {
    private static final L LOG = L.create("Document Your Mod Mod", "Configuration GUI");
    private Map<String, Configuration> configurationMap;

    public void initialize(@Nonnull Minecraft minecraftInstance) {
        LOG.info("GUI Factory initialized");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean hasConfigGui() {
        return true;
    }

    @Nullable
    public GuiScreen createConfigGui(@Nonnull GuiScreen parentScreen) {
        List<IConfigElement> configurationTargets = this.obtainConfigurationTargets();
        if (configurationTargets == null) {
            return new GuiErrorScreen(I18n.func_135052_a((String)"dymm.mod.configuration.error.title", (Object[])new Object[0]), I18n.func_135052_a((String)"dymm.mod.configuration.error.message", (Object[])new Object[0]));
        }
        return new GuiConfig(parentScreen, configurationTargets, "dymm", false, false, "Document Your Mod Mod");
    }

    @Nullable
    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }

    @Nullable
    private List<IConfigElement> obtainConfigurationTargets() {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        Map<String, Configuration> configurations = this.getMapOrElse();
        if (configurations.isEmpty()) {
            return null;
        }
        configurations.forEach((name, configuration) -> elements.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(name + ".cfg", "dymm.mod.configuration." + name, this.getCategories((String)name, (Configuration)configuration))));
        return elements;
    }

    @Nonnull
    private Map<String, Configuration> getMapOrElse() {
        if (this.configurationMap != null) {
            return this.configurationMap;
        }
        try {
            this.configurationMap = this.reflectMap();
            return this.configurationMap;
        }
        catch (RuntimeException e) {
            StringWriter builder = new StringWriter();
            e.printStackTrace(new PrintWriter(builder));
            LOG.bigError("An error has occurred while attempting to obtain the registered configurations!\nSubstituting with an empty map.\nThe stacktrace is the following:\n" + builder.toString(), L.DumpStackBehavior.DO_NOT_DUMP);
            return new HashMap<String, Configuration>();
        }
    }

    @Nonnull
    private Map<String, Configuration> reflectMap() {
        LOG.info("Attempting to reflectively load configuration map");
        try {
            ConfigurationManager manager = ApiBindings.getMainApi().getConfigurationManager();
            Field map = manager.getClass().getDeclaredField("CONFIGURATION_CACHE");
            map.setAccessible(true);
            return (Map)map.get(manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to obtain configurations", e);
        }
    }

    @Nonnull
    private List<IConfigElement> getCategories(@Nonnull String name, @Nonnull Configuration configuration) {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        configuration.getCategoryNames().stream().map(arg_0 -> ((Configuration)configuration).getCategory(arg_0)).filter(it -> !it.isChild()).forEach(it -> elements.add(this.toConfigElement(name, (ConfigCategory)it)));
        return elements;
    }

    @Nonnull
    private IConfigElement toConfigElement(@Nonnull String name, @Nonnull ConfigCategory category) {
        ArrayList children = new ArrayList(category.getChildren());
        ArrayList properties = new ArrayList(category.getOrderedValues());
        List elements = children.stream().map(it -> this.toConfigElement(name, (ConfigCategory)it)).collect(Collectors.toList());
        elements.addAll(properties.stream().map(it -> this.toConfigElement(name, category.getName(), (Property)it)).collect(Collectors.toList()));
        return new DummyConfigElement.DummyCategoryElement(category.getName(), "dymm.mod.configuration." + name + "." + category.getName(), new ArrayList(elements));
    }

    @Nonnull
    private IConfigElement toConfigElement(@Nonnull String name, @Nonnull String categoryName, @Nonnull Property property) {
        return new ConfigurationGuiElement(name, categoryName, property);
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if (this.configurationMap == null) {
            return;
        }
        this.configurationMap.values().forEach(Configuration::save);
        this.configurationMap.values().forEach(Configuration::load);
    }

    private static final class ConfigurationGuiElement
    implements IConfigElement {
        private final String configurationName;
        private final String configurationCategoryName;
        private final Property property;

        private ConfigurationGuiElement(@Nonnull String configurationName, @Nonnull String configurationCategoryName, @Nonnull Property property) {
            this.configurationName = Objects.requireNonNull(configurationName);
            this.configurationCategoryName = Objects.requireNonNull(configurationCategoryName);
            this.property = Objects.requireNonNull(property);
        }

        public boolean isProperty() {
            return true;
        }

        @Nullable
        public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
            return null;
        }

        @Nullable
        public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
            return null;
        }

        @Nonnull
        public String getName() {
            return this.property.getName();
        }

        @Nonnull
        public String getQualifiedName() {
            return this.getName();
        }

        @Nonnull
        public String getLanguageKey() {
            return this.property.getLanguageKey().isEmpty() ? "dymm.mod.configuration." + this.configurationName + "." + this.configurationCategoryName + "." + this.property.getName() : this.property.getLanguageKey();
        }

        @Nonnull
        public String getComment() {
            return this.property.getComment();
        }

        @Nonnull
        public List<IConfigElement> getChildElements() {
            return new ArrayList<IConfigElement>();
        }

        @Nonnull
        public ConfigGuiType getType() {
            return this.toConfigGuiType(this.property.getType());
        }

        public boolean isList() {
            return this.property.isList();
        }

        public boolean isListLengthFixed() {
            return this.property.isListLengthFixed();
        }

        public int getMaxListLength() {
            return this.property.getMaxListLength();
        }

        public boolean isDefault() {
            return this.property.isDefault();
        }

        @Nullable
        public Object getDefault() {
            return this.property.getDefault();
        }

        @Nullable
        public Object[] getDefaults() {
            return this.property.getDefaults();
        }

        public void setToDefault() {
            this.property.setToDefault();
        }

        public boolean requiresWorldRestart() {
            return this.property.requiresWorldRestart();
        }

        public boolean showInGui() {
            return this.property.showInGui();
        }

        public boolean requiresMcRestart() {
            return this.property.requiresMcRestart();
        }

        @Nullable
        public Object get() {
            return this.property.getString();
        }

        @Nullable
        public Object[] getList() {
            return this.property.getStringList();
        }

        public void set(@Nonnull Object value) {
            switch (this.property.getType()) {
                case INTEGER: {
                    this.property.set(Integer.parseInt(value.toString()));
                    break;
                }
                case BOOLEAN: {
                    this.property.set(Boolean.parseBoolean(value.toString()));
                    break;
                }
                case DOUBLE: {
                    this.property.set(Double.parseDouble(value.toString()));
                    break;
                }
                default: {
                    this.property.set(value.toString());
                }
            }
        }

        public void set(@Nonnull Object[] aVal) {
            switch (this.property.getType()) {
                case INTEGER: {
                    this.property.set(Ints.toArray((Collection)Arrays.stream(aVal).map(Object::toString).map(Integer::valueOf).collect(Collectors.toList())));
                    break;
                }
                case BOOLEAN: {
                    this.property.set(Booleans.toArray((Collection)Arrays.stream(aVal).map(Object::toString).map(Boolean::valueOf).collect(Collectors.toList())));
                    break;
                }
                case DOUBLE: {
                    this.property.set(Doubles.toArray((Collection)Arrays.stream(aVal).map(Object::toString).map(Double::valueOf).collect(Collectors.toList())));
                    break;
                }
            }
        }

        @Nonnull
        public String[] getValidValues() {
            return this.property.getValidValues();
        }

        @Nullable
        public Object getMinValue() {
            return this.property.getMinValue();
        }

        @Nullable
        public Object getMaxValue() {
            return this.property.getMaxValue();
        }

        @Nullable
        public Pattern getValidationPattern() {
            return this.property.getValidationPattern();
        }

        @Nonnull
        private ConfigGuiType toConfigGuiType(@Nonnull Property.Type type) {
            switch (type) {
                case STRING: {
                    return ConfigGuiType.STRING;
                }
                case INTEGER: {
                    return ConfigGuiType.INTEGER;
                }
                case BOOLEAN: {
                    return ConfigGuiType.BOOLEAN;
                }
                case DOUBLE: {
                    return ConfigGuiType.DOUBLE;
                }
                case COLOR: {
                    return ConfigGuiType.COLOR;
                }
                case MOD_ID: {
                    return ConfigGuiType.MOD_ID;
                }
            }
            throw new IllegalArgumentException("Not a valid type '" + type + "'");
        }
    }
}

