/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.client;

import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dymm", value={Side.CLIENT})
public final class TooltipEntryRegistryHandler {
    private boolean tooltip;

    private TooltipEntryRegistryHandler() {
        this.readTooltipValue();
    }

    @SubscribeEvent
    public static void onMainMenuGuiOpen(@Nonnull GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu) {
            MinecraftForge.EVENT_BUS.unregister(TooltipEntryRegistryHandler.class);
            MinecraftForge.EVENT_BUS.register((Object)new TooltipEntryRegistryHandler());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent event) {
        this.readTooltipValue();
    }

    @SubscribeEvent
    public void onTooltip(@Nonnull ItemTooltipEvent event) {
        if (!this.tooltip) {
            return;
        }
        List targets = (List)LoadingCacheLazyLoaders.STACKS_CACHE.getUnchecked((Object)event.getItemStack());
        if (targets.isEmpty()) {
            return;
        }
        List tooltip = event.getToolTip();
        tooltip.add(String.format("%s%s:%s", TextFormatting.DARK_AQUA, I18n.func_135052_a((String)"dymm.mod.debug.target_entry", (Object[])new Object[0]), TextFormatting.RESET));
        targets.forEach(it -> tooltip.add(String.format("  %s- %s%s%s", TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY, it.toString(), TextFormatting.RESET)));
    }

    private void readTooltipValue() {
        Configuration config = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_main");
        this.tooltip = config.getBoolean("target_entries", "debug", false, "Shows on the target tooltip which entries are responsible for its documentation");
    }

    private static final class LoadingCacheLazyLoaders {
        private static final LoadingCache<ResourceLocation, List<DocumentationEntry>> DOCUMENTATION_CACHE = LoadingCacheLazyLoaders.createBuilder(2000L).expireAfterAccess(5L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ResourceLocation, List<DocumentationEntry>>(){

            @Nonnull
            public List<DocumentationEntry> load(@Nonnull ResourceLocation key) {
                return ApiBindings.getMainApi().getDocumentationRegistry().getValuesCollection().stream().filter(it -> it.getTargets().stream().map(Target::obtainTarget).map(ItemStack::func_77973_b).map(IForgeRegistryEntry.Impl::getRegistryName).peek(Objects::requireNonNull).anyMatch(arg_0 -> ((ResourceLocation)key).equals(arg_0))).collect(Collectors.toList());
            }
        });
        private static final LoadingCache<ItemStack, List<ResourceLocation>> STACKS_CACHE = LoadingCacheLazyLoaders.createBuilder(7000L).expireAfterAccess(3L, TimeUnit.SECONDS).expireAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ItemStack, List<ResourceLocation>>(){

            @Nonnull
            public List<ResourceLocation> load(@Nonnull ItemStack key) {
                ResourceLocation registryName = key.func_77973_b().getRegistryName();
                if (registryName == null) {
                    return new ArrayList<ResourceLocation>();
                }
                List entryCandidates = (List)DOCUMENTATION_CACHE.getUnchecked((Object)registryName);
                ArrayList<ResourceLocation> correctTargets = new ArrayList<ResourceLocation>();
                entryCandidates.forEach(candidate -> {
                    boolean matches = false;
                    for (Target target : candidate.getTargets()) {
                        if (matches) break;
                        ItemStack stack = target.obtainTarget();
                        matches = ItemStack.func_179545_c((ItemStack)stack, (ItemStack)key);
                        if (!matches || !stack.func_77942_o() || (matches = ItemStack.func_77970_a((ItemStack)stack, (ItemStack)key)) || key.func_82837_s() && stack.func_82837_s() || !key.func_82837_s()) continue;
                        stack.func_151001_c(key.func_82833_r());
                        matches = ItemStack.func_77970_a((ItemStack)stack, (ItemStack)key);
                    }
                    if (!matches) {
                        return;
                    }
                    correctTargets.add(candidate.getRegistryName());
                });
                return correctTargets;
            }
        });

        private LoadingCacheLazyLoaders() {
        }

        private static CacheBuilder<Object, Object> createBuilder(long maximumSize) {
            Configuration config = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_main");
            boolean isRamSaving = config.getBoolean("ram_saving", "performance", false, "Makes the mod run in RAM-light mode, making it allocate as few resources as possible.\nWARNING! This WILL exponentially decrease performance up to 70%! Use this option if you REALLY need to spare as much RAM as possible!\nIn most cases this mod can automatically regulate itself, so turn this on ONLY if you've already tried everything! Do NOT come to us for huge slowdowns");
            CacheBuilder builder = CacheBuilder.newBuilder();
            return isRamSaving ? builder.maximumSize(maximumSize) : builder;
        }
    }
}

