/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common;

import com.aaronhowser1.dymm.api.ApiBindings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class ModDescriptionUpdatingHandler {
    private static final Map<String, List<String>> SUPPORTED_VERSIONS = new HashMap<String, List<String>>();

    public static void addVersion(@Nonnull String id, @Nonnull List<String> supportedVersions) {
        Objects.requireNonNull(supportedVersions);
        SUPPORTED_VERSIONS.put(id, supportedVersions);
    }

    public static void updateModDescription() {
        ModContainer container = Loader.instance().getModList().stream().filter(it -> it.getModId().equals("dymm")).findFirst().orElseThrow(RuntimeException::new);
        ModMetadata metadata = container.getMetadata();
        metadata.description = ModDescriptionUpdatingHandler.updateModDescription(metadata.description);
    }

    @Nonnull
    private static String updateModDescription(@Nonnull String oldDescription) {
        ModDescriptionUpdatingHandler.updateMap();
        StringBuilder builder = new StringBuilder(oldDescription);
        builder.append("\n\nMod support status:\n");
        ModDescriptionUpdatingHandler.sortCompatibilityList(ModDescriptionUpdatingHandler.buildCompatibilityList()).forEach(it -> {
            builder.append(((Support)((Object)((Object)it.getRight()))).getColor());
            builder.append("  - ");
            builder.append(((ModContainer)it.getLeft()).getName());
            builder.append(' ');
            builder.append(ModDescriptionUpdatingHandler.formatIpBased(((ModContainer)it.getLeft()).getDisplayVersion(), ((Support)((Object)((Object)it.getRight()))).getColor()));
            builder.append(" (");
            builder.append(ModDescriptionUpdatingHandler.formatIpBased(ModDescriptionUpdatingHandler.format(((Support)((Object)((Object)it.getRight()))).getFriendlyName()), ((Support)((Object)((Object)it.getRight()))).getColor()));
            builder.append(')');
            builder.append(TextFormatting.RESET);
            builder.append('\n');
        });
        return builder.toString();
    }

    private static void updateMap() {
        ApiBindings.getMainApi().getDocumentationRegistry().getEntries().stream().map(Map.Entry::getKey).map(ResourceLocation::func_110624_b).forEach(it -> SUPPORTED_VERSIONS.computeIfAbsent((String)it, key -> new ArrayList()));
    }

    @Nonnull
    private static List<Pair<ModContainer, Support>> buildCompatibilityList() {
        return Loader.instance().getModList().stream().map(it -> ImmutablePair.of((Object)it, (Object)((Object)ModDescriptionUpdatingHandler.getContainerSupportLevel(it)))).collect(Collectors.toList());
    }

    @Nonnull
    private static Support getContainerSupportLevel(@Nonnull ModContainer container) {
        String modId = container.getModId();
        String currentVersion = container.getDisplayVersion();
        List<String> supportedVersions = SUPPORTED_VERSIONS.get(modId);
        if (supportedVersions == null) {
            return Support.NOT_SUPPORTED;
        }
        if (supportedVersions.isEmpty()) {
            return Support.INFO_NOT_PROVIDED;
        }
        if (supportedVersions.contains(currentVersion)) {
            return Support.FULL_SUPPORT;
        }
        String highest = ModDescriptionUpdatingHandler.findHighestVersion(supportedVersions);
        String actualHighest = ModDescriptionUpdatingHandler.findHighestVersion(highest, currentVersion);
        return actualHighest.equals(highest) ? Support.DOCUMENTATION_NEWER_THAN_MOD : Support.DOCUMENTATION_OUT_OF_DATE;
    }

    @Nonnull
    private static String findHighestVersion(@Nonnull List<String> strings) {
        String highest = strings.get(0);
        if (strings.size() == 1) {
            return highest;
        }
        for (String version : strings) {
            highest = ModDescriptionUpdatingHandler.findHighestVersion(highest, version);
        }
        return highest;
    }

    @Nonnull
    private static String findHighestVersion(@Nonnull String a, @Nonnull String b) {
        return a.equals(b) ? a : ModDescriptionUpdatingHandler.compareVersionString(a, b);
    }

    @Nonnull
    private static String compareVersionString(@Nonnull String a, @Nonnull String b) {
        if (a.startsWith("1.12.2-")) {
            return ModDescriptionUpdatingHandler.compareVersionString(a.substring("1.12.2-".length()), b);
        }
        if (a.startsWith("1.12.2")) {
            return ModDescriptionUpdatingHandler.compareVersionString(a.substring("1.12.2".length()), b);
        }
        if (b.startsWith("1.12.2-")) {
            return ModDescriptionUpdatingHandler.compareVersionString(a, b.substring("1.12.2-".length()));
        }
        if (b.startsWith("1.12.2")) {
            return ModDescriptionUpdatingHandler.compareVersionString(a, b.substring("1.12.2".length()));
        }
        return ModDescriptionUpdatingHandler.compareVersion((ArtifactVersion)new DefaultArtifactVersion(a), (ArtifactVersion)new DefaultArtifactVersion(b));
    }

    @Nonnull
    private static String compareVersion(@Nonnull ArtifactVersion a, @Nonnull ArtifactVersion b) {
        return a.compareTo((Object)b) > 0 ? a.toString() : b.toString();
    }

    @Nonnull
    private static List<Pair<ModContainer, Support>> sortCompatibilityList(@Nonnull List<Pair<ModContainer, Support>> unsorted) {
        ArrayList<Pair<ModContainer, Support>> sorted = new ArrayList<Pair<ModContainer, Support>>();
        unsorted.sort(Comparator.comparing(it -> ((ModContainer)it.getLeft()).getName().toLowerCase(Locale.ENGLISH)));
        unsorted.stream().filter(it -> it.getRight() == Support.FULL_SUPPORT).forEach(sorted::add);
        unsorted.stream().filter(it -> it.getRight() == Support.DOCUMENTATION_OUT_OF_DATE).forEach(sorted::add);
        unsorted.stream().filter(it -> it.getRight() == Support.DOCUMENTATION_NEWER_THAN_MOD).forEach(sorted::add);
        unsorted.stream().filter(it -> it.getRight() == Support.INFO_NOT_PROVIDED).forEach(sorted::add);
        unsorted.stream().filter(it -> it.getRight() == Support.NOT_SUPPORTED).forEach(sorted::add);
        return sorted;
    }

    @Nonnull
    private static String format(@Nonnull String string) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            return I18n.func_135052_a((String)string, (Object[])new Object[0]);
        }
        return string;
    }

    @Nonnull
    private static String formatIpBased(@Nonnull String string, @Nonnull TextFormatting color) {
        int dots = StringUtils.countMatches((CharSequence)string, (char)'.');
        if (dots < 3) {
            return string;
        }
        String[] split = string.split(Pattern.quote("."));
        String colorAdder = "" + TextFormatting.RESET + color;
        return Arrays.stream(split).collect(Collectors.joining("." + colorAdder, "", colorAdder));
    }

    private static enum Support {
        FULL_SUPPORT("dymm.mod.support.full_support", TextFormatting.DARK_GREEN),
        DOCUMENTATION_OUT_OF_DATE("dymm.mod.support.documentation_out_of_date", TextFormatting.GOLD),
        DOCUMENTATION_NEWER_THAN_MOD("dymm.mod.support.documentation_newer_than_mod", TextFormatting.RED),
        INFO_NOT_PROVIDED("dymm.mod.support.info_not_provided", TextFormatting.DARK_PURPLE),
        NOT_SUPPORTED("dymm.mod.support.not_supported", TextFormatting.GRAY);

        private final String friendlyName;
        private final TextFormatting color;

        private Support(String friendlyName, TextFormatting color) {
            this.friendlyName = friendlyName;
            this.color = color;
        }

        @Nonnull
        private String getFriendlyName() {
            return this.friendlyName;
        }

        @Nonnull
        private TextFormatting getColor() {
            return this.color;
        }
    }
}

