/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public final class ConfigurationManager
implements com.aaronhowser1.dymm.api.configuration.ConfigurationManager {
    private static final Map<String, Configuration> CONFIGURATION_CACHE = new HashMap<String, Configuration>();

    private ConfigurationManager() {
    }

    @Nonnull
    public static ConfigurationManager get() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    @Nonnull
    public final Configuration getVersionedConfigurationFor(@Nonnull String name, @Nonnull String version) {
        return CONFIGURATION_CACHE.computeIfAbsent(name, it -> {
            Configuration configuration = new Configuration(this.getFileFor(name), version);
            configuration.load();
            configuration.save();
            return configuration;
        });
    }

    @Override
    @Nonnull
    public final Configuration getConfigurationFor(@Nonnull String name) {
        return this.getVersionedConfigurationFor(name, "1");
    }

    @Nonnull
    private File getFileFor(@Nonnull String name) {
        try {
            return this.getPathFor(name).toFile().getCanonicalFile();
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("An error has occurred while attempting to construct the configuration for '" + name + "'", e);
        }
    }

    @Nonnull
    private Path getPathFor(@Nonnull String name) {
        Path mainConfigurationDirectory = Loader.instance().getConfigDir().toPath();
        Path documentConfigurationDirectory = mainConfigurationDirectory.resolve("./dymm");
        return documentConfigurationDirectory.resolve("./" + name + ".cfg").normalize().toAbsolutePath();
    }

    private static final class InstanceHolder {
        private static final ConfigurationManager INSTANCE = new ConfigurationManager();

        private InstanceHolder() {
        }
    }
}

