/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.configuration;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.ApiBindings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;

public final class OldConfigurationMigrationTool {
    private static final List<MigrationMapping> MIGRATION_MAPPINGS = new ArrayList<MigrationMapping>();
    private static final L LOG = L.create("Document Your Mod Mod", "Configuration Migration");

    private OldConfigurationMigrationTool() {
    }

    public static void attemptToMigrateConfiguration() {
        Path oldConfigurationPath = Loader.instance().getConfigDir().toPath().resolve("./dym.cfg").normalize().toAbsolutePath();
        if (!Files.exists(oldConfigurationPath, new LinkOption[0])) {
            LOG.info("No old configuration to migrate was found");
            return;
        }
        OldConfigurationMigrationTool.doConfigurationMigration(oldConfigurationPath);
    }

    private static void doConfigurationMigration(@Nonnull Path oldConfiguration) {
        LOG.bigWarn("An old configuration file was found inside your configuration directory!\nThis file will now be migrated to the new location and all settings (if possible), will be carried over\nNote that this process will only be done once and then the old configuration will be deleted!\n\nThe new configuration has been migrated to its own directory and split for ease of editing");
        Configuration old = new Configuration(oldConfiguration.toFile());
        old.load();
        old.getCategoryNames().stream().map(arg_0 -> ((Configuration)old).getCategory(arg_0)).forEach(category -> {
            String categoryName = category.getQualifiedName();
            category.forEach((name, property) -> {
                Optional<MigrationMapping> mapping = MIGRATION_MAPPINGS.stream().filter(it -> ((MigrationMapping)it).oldCategory.equals(categoryName) && ((MigrationMapping)it).oldName.equals(name)).findFirst();
                if (!mapping.isPresent()) {
                    LOG.warn("Unable to find a mapping for the entry '" + categoryName + '.' + name + ": this entry will not be migrated!");
                    return;
                }
                MigrationMapping map = mapping.get();
                Configuration newConfiguration = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor(map.newFileName);
                ConfigCategory newCategory = newConfiguration.getCategory(map.newCategory);
                Property newProperty = newCategory.get(map.newName);
                if (newProperty != null) {
                    newProperty.set(property.getBoolean());
                } else {
                    newConfiguration.get(map.newCategory, map.newName, property.getBoolean(), property.getComment());
                }
                newConfiguration.save();
            });
        });
        LOG.info("Migration process completed successfully: the old file will now be deleted");
        Path newLocation = Loader.instance().getConfigDir().toPath().resolve("./dymm/_migration.backup");
        if (Files.exists(newLocation, new LinkOption[0])) {
            try {
                Files.delete(newLocation);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Files.move(oldConfiguration, newLocation, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.warn("An error has occurred while operating on the old file", (Throwable)e);
        }
    }

    static {
        String mFile = "_main";
        String tFile = "_targets";
        String qFile = "quark";
        String gCat = "general";
        String qCat = "general.quark";
        String dCat = "debug";
        String tCat = "targets";
        String mCat = "targets";
        MIGRATION_MAPPINGS.add(new MigrationMapping("general", "Debug - Mod Documented", "_main", "debug", "target_documented"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general", "Debug - Not Documented Items", "_main", "debug", "missing_entries"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general", "Iron Chest info", "_targets", "targets", "ironchest"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general", "Nature's Compass info", "_targets", "targets", "naturescompass"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general", "Refined Storage info", "_targets", "targets", "refinedstorage"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general", "Tinkers' Construct info", "_targets", "targets", "tconstruct"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general", "Twilight Forest info", "_targets", "targets", "twilightforest"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general", "Waystones info", "_targets", "targets", "waystones"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general.quark", "Quark Info", "_targets", "targets", "quark"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general.quark", "Quark's Decorative Blocks", "quark", "targets", "decorative_blocks"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general.quark", "Quark's GUI Elements", "quark", "targets", "gui_element"));
        MIGRATION_MAPPINGS.add(new MigrationMapping("general.quark", "Quark's Vanilla Info", "quark", "targets", "vanilla"));
    }

    private static final class MigrationMapping {
        private final String oldCategory;
        private final String oldName;
        private final String newFileName;
        private final String newCategory;
        private final String newName;

        private MigrationMapping(@Nonnull String oldCategory, @Nonnull String oldName, @Nonnull String newFileName, @Nonnull String newCategory, @Nonnull String newName) {
            this.oldCategory = oldCategory;
            this.oldName = oldName;
            this.newFileName = newFileName;
            this.newCategory = newCategory;
            this.newName = newName;
        }
    }
}

