/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.loading;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.loading.DocumentationLoader;
import com.aaronhowser1.dymm.api.loading.metadata.MetadataListener;
import com.aaronhowser1.dymm.api.loading.metadata.MetadataListenerRegistry;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public enum LoaderRegistry implements MetadataListenerRegistry
{
    INSTANCE;

    private static final L LOG;
    private final Map<ResourceLocation, DocumentationLoader> loaders = new HashMap<ResourceLocation, DocumentationLoader>();
    private final Map<String, List<MetadataListener>> listenersMap = new HashMap<String, List<MetadataListener>>();

    public void discoverLoadersFromClasspath() {
        this.loaders.clear();
        LOG.info("Discovering loaders on the classpath");
        ServiceLoader<DocumentationLoader> serviceLoader = ServiceLoader.load(DocumentationLoader.class);
        serviceLoader.iterator().forEachRemaining(it -> {
            ResourceLocation id = it.getIdentifier();
            LOG.debug("Found loader '" + id + "' with implementation '" + it + "' @ " + it.getClass().getName());
            if (this.loaders.get(id) != null) {
                if (this.loaders.get(id) == it) {
                    LOG.bigWarn("The loader '" + id + "' has been found twice on the classpath, with the same implementation!\nWhile this is not an issue, it will not be registered again to prevent overrides.\nThis most of the times indicates a broken mod installation or environment setup: please check it");
                    return;
                }
                LOG.bigError("Two loaders with the same identifier '" + id + "' were found on the classpath\nLoader overriding is not supported and this attempt will be blocked immediately!\nThe game loading process cannot continue!\n\nCurrent loader class: " + this.loaders.get(id).getClass().getName() + "\nOverride-attempting loader class: " + it.getClass().getName());
                throw new IllegalStateException("Found two loaders with the same id '" + id + "': game cannot continue loading");
            }
            this.loaders.put(id, (DocumentationLoader)it);
            it.onLoad();
        });
        LOG.info("Loader discovery completed: found a total of " + this.loaders.size() + " loaders");
        LOG.debug("Dumping loaders: ");
        this.loaders.forEach((k, v) -> LOG.debug("    " + k + " -> " + v.getClass().getName()));
    }

    public void registerMetadataListeners() {
        this.listenersMap.clear();
        LOG.info("Attempting to discover and register metadata listeners for all loaders");
        this.loaders.values().forEach(it -> it.registerMetadataListeners(this));
        LOG.info("Metadata listener registration completed: a total of " + this.listenersMap.values().stream().mapToLong(Collection::size).sum() + " listeners were registered");
        LOG.debug("Dumping metadata listeners: ");
        this.listenersMap.forEach((k, v) -> {
            LOG.debug("    - " + k);
            v.forEach(it -> LOG.debug("        " + it.getClass().getName()));
        });
    }

    @Override
    public void register(@Nonnull String metadataIdentifier, @Nonnull MetadataListener listener) {
        Preconditions.checkNotNull((Object)metadataIdentifier, (Object)"Unable to register a null metadata identifier");
        Preconditions.checkNotNull((Object)listener, (Object)"Unable to register a null listener");
        Preconditions.checkArgument((!metadataIdentifier.isEmpty() ? 1 : 0) != 0, (Object)"Metadata identifier cannot be empty");
        this.listenersMap.computeIfAbsent(metadataIdentifier, it -> new ArrayList()).add(listener);
        LOG.debug("Registered " + metadataIdentifier + " -> " + listener);
    }

    @Override
    @Nonnull
    public List<MetadataListener> findAllFor(@Nonnull String metadataIdentifier) {
        Preconditions.checkNotNull((Object)metadataIdentifier, (Object)"Unable to register a null metadata identifier");
        Preconditions.checkArgument((!metadataIdentifier.isEmpty() ? 1 : 0) != 0, (Object)"Metadata identifier cannot be empty");
        return this.listenersMap.computeIfAbsent(metadataIdentifier, it -> new ArrayList());
    }

    void fireEvent() {
        this.loaders.values().forEach(DocumentationLoader::onGlobalLoadingStateUnbinding);
    }

    void fireEvent(@Nonnull JsonObject object, @Nonnull String identifier, @Nonnull String namespace) {
        this.findAllFor(identifier).forEach(it -> it.processMetadata(object, namespace));
    }

    @Nullable
    DocumentationLoader findLoader(@Nonnull ResourceLocation name) {
        return this.loaders.get(name);
    }

    static {
        LOG = L.create("Document Your Mod Mod", "Loader Registry");
    }
}

