/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.loading;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.loading.DocumentationLoader;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.Reporter;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.common.loading.DocumentationLoadingProcessor;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Context;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public final class LoadingState
implements GlobalLoadingState,
Reporter {
    private static LoadingState GLOBAL = null;
    private ResourceLocation targetId;
    private L l;
    private DocumentationLoader loader;
    private Context globalContext;

    private LoadingState() {
    }

    @Nullable
    public static LoadingState obtainState() {
        return GLOBAL;
    }

    static void rebuild(@Nonnull ResourceLocation targetId, @Nonnull L l, @Nonnull DocumentationLoader loader, @Nonnull Context globalContext) {
        if (GLOBAL == null) {
            GLOBAL = new LoadingState();
        }
        GLOBAL.apply(targetId, l, loader, globalContext);
    }

    static void l(@Nonnull L l) {
        if (GLOBAL == null) {
            return;
        }
        LoadingState.GLOBAL.l = Objects.requireNonNull(l);
    }

    static void destroyCurrent() {
        GLOBAL = null;
    }

    private void apply(@Nonnull ResourceLocation targetId, @Nonnull L l, @Nonnull DocumentationLoader loader, @Nonnull Context globalContext) {
        this.targetId = Objects.requireNonNull(targetId);
        this.l = Objects.requireNonNull(l);
        this.loader = Objects.requireNonNull(loader);
        this.globalContext = Objects.requireNonNull(globalContext);
    }

    @Override
    @Nonnull
    public Reporter getReporter() {
        return this;
    }

    @Override
    @Nonnull
    public ConditionFactory getConditionFactory(@Nonnull ResourceLocation location) {
        ConditionFactory factory = (ConditionFactory)DocumentationLoadingProcessor.get(this.globalContext, "condition").get(location);
        if (factory == null) {
            throw new IllegalArgumentException("The given identifier '" + location + "' does not represent a known condition factory");
        }
        return factory;
    }

    @Override
    @Nonnull
    public TargetFactory getTargetFactory(@Nonnull ResourceLocation location) {
        TargetFactory factory = (TargetFactory)DocumentationLoadingProcessor.get(this.globalContext, "target").get(location);
        if (factory == null) {
            throw new IllegalArgumentException("The given identifier '" + location + "' does not represent a known target factory");
        }
        return factory;
    }

    @Override
    public void notify(@Nonnull String message, Object ... arguments) {
        this.l.info("In '" + this.targetId + "': " + message, arguments);
    }

    @Override
    public void report(@Nonnull String message, Object ... arguments) {
        this.l.warn("In '" + this.targetId + "': " + message, arguments);
    }

    @Override
    public void interrupt(@Nonnull String message, Object ... arguments) {
        this.l.error("An error has occurred in loader '" + this.loader.getIdentifier() + "' while attempting to load '" + this.targetId + "'");
        this.l.error(message, arguments);
    }
}

