/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class ConfigurationOptionConditionFactory
implements ConditionFactory {
    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String configuration = JsonUtilities.getString(object, "configuration");
        String category = JsonUtilities.getString(object, "category");
        String name = JsonUtilities.getString(object, "name");
        boolean value = JsonUtilities.getBooleanOrElse(object, "value", () -> true);
        Configuration targetConfiguration = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor(configuration);
        ConfigCategory configurationCategory = targetConfiguration.getCategory(category);
        Property property = configurationCategory.get(name);
        boolean configurationValue = property.getBoolean();
        return new BasicCondition(configurationValue == value);
    }
}

