/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.module.base.BasicItemTarget;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class MetadataRangeItemTargetFactory
implements TargetFactory {
    @Override
    @Nonnull
    public List<Target> fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String registryName = JsonUtilities.getString(object, "registry_name");
        int metadataBegin = JsonUtilities.getInt(object, "metadata_begin");
        int metadataEnd = JsonUtilities.getInt(object, "metadata_end");
        boolean startInclusive = JsonUtilities.getBooleanOrElse(object, "include_start", () -> true);
        boolean endInclusive = JsonUtilities.getBooleanOrElse(object, "include_end", () -> true);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
        if (item == null || item == Items.field_190931_a) {
            state.getReporter().report("The registry name '" + registryName + "' does not match any known item: it will be skipped", new Object[0]);
            return new ArrayList<Target>();
        }
        return IntStream.rangeClosed(metadataBegin + (startInclusive ? 0 : 1), metadataEnd - (endInclusive ? 0 : 1)).mapToObj(it -> new ItemStack(item, 1, it)).map(BasicItemTarget::new).collect(Collectors.toList());
    }
}

