/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.module.base.BasicItemTarget;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class PotionTargetFactory
implements TargetFactory {
    @Override
    @Nonnull
    public List<Target> fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        Set<PotionType> types = this.getTypesFromJson(state, object);
        String effect = this.checkPresence(state, JsonUtilities.getString(object, "effect"));
        return types.stream().map(it -> this.convertToItem((PotionType)((Object)it), effect)).map(BasicItemTarget::new).collect(Collectors.toList());
    }

    @Nonnull
    private Set<PotionType> getTypesFromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String type = JsonUtilities.getString(object, "kind");
        if ("all".equals(type)) {
            state.getReporter().report("Found deprecated 'all' kind, it will match " + Arrays.toString((Object[])PotionType.values()) + ": prefer specifying them explicitly!", new Object[0]);
            return new HashSet<PotionType>(Arrays.asList(PotionType.values()));
        }
        HashSet<PotionType> types = new HashSet<PotionType>();
        Arrays.stream(PotionType.values()).filter(it -> type.equals(it.toString())).findFirst().ifPresent(types::add);
        if (types.isEmpty()) {
            throw new JsonParseException("The given kind '" + type + "' is not recognized as the ID of a valid potion type. Valid ones are: " + Arrays.toString((Object[])PotionType.values()));
        }
        return types;
    }

    @Nonnull
    private String checkPresence(@Nonnull GlobalLoadingState state, @Nonnull String effect) {
        net.minecraft.potion.PotionType vanillaType = (net.minecraft.potion.PotionType)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation(effect));
        if (vanillaType == null || new ResourceLocation("empty").equals((Object)vanillaType.getRegistryName())) {
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effect));
            if (potion == null) {
                state.getReporter().report("The given effect '" + effect + "' does not exist: the entry will be registered anyway, but it won't work!", new Object[0]);
            } else {
                state.getReporter().report("The given effect '" + effect + "' is the name of a potion: you need to use the potion type, otherwise the entry will not work", new Object[0]);
            }
        }
        return effect;
    }

    @Nonnull
    private ItemStack convertToItem(@Nonnull PotionType type, @Nonnull String effect) {
        Item item = type.getCorrespondingItem();
        NBTTagCompound tag = this.generateTagCompound(effect);
        ItemStack stack = new ItemStack(item, 1, 0, tag);
        stack.func_77982_d(tag);
        return stack;
    }

    @Nonnull
    private NBTTagCompound generateTagCompound(@Nonnull String effect) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("Potion", effect);
        return tagCompound;
    }

    private static enum PotionType {
        NORMAL((Item)Items.field_151068_bn),
        SPLASH((Item)Items.field_185155_bH),
        LINGERING((Item)Items.field_185156_bI),
        ARROW_HEAD(Items.field_185167_i);

        private final Item correspondingItem;

        private PotionType(Item correspondingItem) {
            this.correspondingItem = correspondingItem;
        }

        @Nonnull
        private Item getCorrespondingItem() {
            return this.correspondingItem;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

