/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base.nbt;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.loading.metadata.MetadataListener;
import com.aaronhowser1.dymm.module.base.nbt.NbtFactory;
import com.aaronhowser1.dymm.module.base.nbt.NbtFactoryRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;

public final class NbtFactoriesMetadataListener
implements MetadataListener {
    @Override
    public void processMetadata(@Nonnull JsonObject object, @Nonnull String nameSpace) {
        if (!"dymm".equals(nameSpace)) {
            throw new JsonParseException("Only the default namespace is allowed to specify a 'nbt_factories' metadata file");
        }
        object.entrySet().forEach(it -> {
            block2: {
                String tagType = (String)it.getKey();
                String factoryClassName = JsonUtilities.asString((JsonElement)it.getValue(), tagType);
                NbtFactory factory = this.instantiateFactoryFromClassName(factoryClassName);
                try {
                    NbtFactoryRegistry.INSTANCE.registerFactory(tagType, factory);
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("factory assigned already")) break block2;
                    throw e;
                }
            }
        });
    }

    @Nonnull
    private <T extends NBTBase> NbtFactory<T> instantiateFactoryFromClassName(@Nonnull String name) {
        try {
            Class<?> tClass = Class.forName(name);
            Object instance = tClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (NbtFactory)instance;
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new JsonParseException("Unable to find specified class '" + name + "' when initializing factory", (Throwable)e);
        }
    }
}

