/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base.nbt;

import com.aaronhowser1.dymm.module.base.nbt.NbtFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;

public enum NbtFactoryRegistry {
    INSTANCE;

    private final Map<String, NbtFactory<?>> REGISTRY = new HashMap();

    <T extends NBTBase> void registerFactory(@Nonnull String mnemonic, @Nonnull NbtFactory<T> type) {
        if (this.REGISTRY.containsKey(mnemonic)) {
            throw new IllegalStateException("The given mnemonic '" + mnemonic + "' had a factory assigned already");
        }
        this.REGISTRY.put(mnemonic, type);
    }

    public <T extends NBTBase> NbtFactory<T> getForType(@Nonnull String mnemonic) {
        try {
            return Objects.requireNonNull(this.REGISTRY.get(mnemonic));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("The given mnemonic '" + mnemonic + "' is not a valid NBT type", e);
        }
    }
}

