/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.inspirations.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;

public final class ConfigurationOptionConditionFactory
implements ConditionFactory {
    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String value = JsonUtilities.getString(object, "value");
        try {
            return new BasicCondition(this.reflectInto(value));
        }
        catch (ReflectiveOperationException e) {
            throw new JsonParseException("Unable to reflectively load value '" + value + "' from the configuration file");
        }
    }

    private boolean reflectInto(@Nonnull String fieldName) throws ReflectiveOperationException {
        Class<?> configurationClass = Class.forName("knightminer.inspirations.common.Config");
        Field targetField = configurationClass.getDeclaredField(fieldName);
        if (targetField.isAccessible()) {
            throw new JsonParseException("Target configuration field '" + fieldName + "'is not accessible");
        }
        Object value = targetField.get(configurationClass);
        if (!(value instanceof Boolean)) {
            throw new JsonParseException("Target field '" + fieldName + "' did not store a boolean value: this is invalid");
        }
        return (Boolean)value;
    }
}

