/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.jei.consume;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.consume.DocumentationDataConsumer;
import com.aaronhowser1.dymm.api.documentation.DocumentationData;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@JEIPlugin
public final class JeiDocumentationConsumer
implements DocumentationDataConsumer,
IModPlugin {
    private static final L LOG = L.create("Document Your Mod Mod", "JEI Integration");
    private static final List<Pair<DocumentationData, Set<Target>>> DATA = new ArrayList<Pair<DocumentationData, Set<Target>>>();

    @Override
    @Nonnull
    public List<ResourceLocation> getCompatibleTypes() {
        return ImmutableList.of((Object)new ResourceLocation("jei", "information"));
    }

    @Override
    public void consumeData(@Nonnull DocumentationData data, @Nonnull Set<Target> targets) {
        DATA.add((Pair<DocumentationData, Set<Target>>)ImmutablePair.of((Object)data, targets));
    }

    public void register(IModRegistry registry) {
        LOG.info("It's time: JEI are you ready to get a lot of sweet data?");
        LOG.info("Beginning integration");
        DATA.forEach(it -> {
            Set<ItemStack> targets = ((Set)it.getRight()).stream().map(Target::obtainTarget).collect(Collectors.toSet());
            String[] pages = (String[])((DocumentationData)it.getLeft()).getData().stream().peek(this::checkLine).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).toArray(String[]::new);
            targets.forEach(target -> registry.addIngredientInfo(target, VanillaTypes.ITEM, pages));
        });
        LOG.info("Integration completed: registered a total of " + DATA.size() + " entries");
    }

    private void checkLine(@Nonnull String line) {
        if (!I18n.func_188566_a((String)line)) {
            LOG.warn("Found not localized line '" + line + "' in one of the entries! Check your language file");
        }
    }
}

