/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.minecraft.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.module.base.BasicItemTarget;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class DynamicNbtItemTargetFactory
implements TargetFactory {
    @Override
    @Nonnull
    public List<Target> fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String registryName = JsonUtilities.getString(object, "registry_name");
        int metadata = JsonUtilities.getIntOrElse(object, "metadata", () -> -1);
        ArrayList<Target> targets = new ArrayList<Target>();
        Item mainItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
        if (mainItem == null || mainItem == Items.field_190931_a) {
            state.getReporter().report("No dynamic NBT item with the given registry name '" + registryName + "' exists: addition will be skipped", new Object[0]);
            return targets;
        }
        NonNullList nonNullList = NonNullList.func_191196_a();
        mainItem.func_150895_a(CreativeTabs.field_78027_g, nonNullList);
        Predicate<ItemStack> filter = metadata == -1 ? it -> true : it -> it.func_77960_j() == metadata;
        nonNullList.stream().filter(filter).map(BasicItemTarget::new).forEach(targets::add);
        return targets;
    }
}

