/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.minecraft.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.module.base.BasicItemTarget;
import com.aaronhowser1.dymm.module.base.nbt.NbtFactoryRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class ItemTargetFactory
implements TargetFactory {
    @Override
    @Nonnull
    public List<Target> fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String registryName = JsonUtilities.getString(object, "registry_name");
        int metadata = JsonUtilities.getIntOrElse(object, "metadata", () -> 0);
        NBTTagCompound nbtCompound = this.parseNbt(state, object);
        ArrayList<Target> returnList = new ArrayList<Target>();
        Item item = this.getFromRegistry(state, registryName);
        if (item == null) {
            return returnList;
        }
        ItemStack stack = new ItemStack(item, 1, metadata);
        if (nbtCompound != null) {
            stack.deserializeNBT(nbtCompound);
        }
        returnList.add(new BasicItemTarget(stack));
        return returnList;
    }

    @Nullable
    private NBTTagCompound parseNbt(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        if (!object.has("nbt")) {
            return null;
        }
        return this.convertToNbt(state, JsonUtilities.getJsonObject(object, "nbt"));
    }

    @Nonnull
    private NBTTagCompound convertToNbt(@Nonnull GlobalLoadingState state, @Nonnull JsonObject nbt) {
        NBTTagCompound base = new NBTTagCompound();
        base.func_74778_a("id", "minecraft:air");
        base.func_74774_a("Count", (byte)1);
        base.func_74777_a("Damage", (short)0);
        try {
            base.func_74782_a("tag", NbtFactoryRegistry.INSTANCE.getForType("compound").parseFromJson("tag", (JsonElement)nbt, 0));
        }
        catch (Exception e) {
            state.getReporter().interrupt("An error has occurred while attempting to read the NBT from the JSON file: maybe a syntax error?", new Object[0]);
            throw new JsonParseException((Throwable)e);
        }
        return base;
    }

    @Nullable
    private Item getFromRegistry(@Nonnull GlobalLoadingState state, @Nonnull String registryName) {
        return this.getFromRegistry(state, new ResourceLocation(registryName));
    }

    @Nullable
    private Item getFromRegistry(@Nonnull GlobalLoadingState state, @Nonnull ResourceLocation registryName) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
        if (item == null || item == Items.field_190931_a) {
            state.getReporter().report("No item with the given registry name '" + registryName + "' exists: addition will be skipped", new Object[0]);
            return null;
        }
        return item;
    }
}

