/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.quark.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.common.base.CaseFormat;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class ModuleFeatureEnabledConditionFactory
implements ConditionFactory {
    private static final Map<String, Boolean> MODULE_CACHE = new HashMap<String, Boolean>();
    private static final Map<String, Condition> FEATURE_CACHE = new HashMap<String, Condition>();
    private static final String EMPTY_FEATURE = "";

    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String module = JsonUtilities.getString(object, "module");
        if (!module.toLowerCase(Locale.ENGLISH).equals(module)) {
            throw new JsonSyntaxException("Module name '" + module + "' is invalid: must be lowercase");
        }
        String feature = JsonUtilities.getStringOrElse(object, "feature", () -> EMPTY_FEATURE);
        if (!feature.toLowerCase(Locale.ENGLISH).equals(feature)) {
            throw new JsonSyntaxException("Feature name '" + feature + "' is invalid: must be lowercase");
        }
        boolean isEnabled = MODULE_CACHE.computeIfAbsent(module, it -> {
            try {
                return this.isModuleEnabled((String)it);
            }
            catch (ReflectiveOperationException e) {
                throw new JsonParseException("Given module '" + it + "' couldn't be found", (Throwable)e);
            }
        });
        if (!isEnabled) {
            state.getReporter().notify("Skipping condition checking for feature '" + feature + "' since parent module '" + module + "' isn't enabled", new Object[0]);
            return new BasicCondition(false);
        }
        if (EMPTY_FEATURE.equals(feature)) {
            return new BasicCondition(true);
        }
        return FEATURE_CACHE.computeIfAbsent(feature, it -> {
            try {
                return new BasicCondition(this.isFeatureEnabled(module, (String)it));
            }
            catch (ReflectiveOperationException e) {
                throw new JsonParseException("Given feature '" + it + "' couldn't be found in module '" + module + "'", (Throwable)e);
            }
        });
    }

    private boolean isModuleEnabled(@Nonnull String packageName) throws ReflectiveOperationException {
        String className = "Quark" + StringUtils.capitalize((String)packageName);
        Class<?> targetClass = Class.forName(String.format("vazkii.quark.%s.%s", packageName, className));
        Class<?> moduleClass = Class.forName("vazkii.quark.base.module.Module");
        if (!moduleClass.isAssignableFrom(targetClass)) {
            throw new JsonParseException("The given module '" + packageName + "' is not a valid Quark module");
        }
        Class<?> moduleLoader = Class.forName("vazkii.quark.base.module.ModuleLoader");
        Method isModuleEnabled = moduleLoader.getDeclaredMethod("isModuleEnabled", Class.class);
        isModuleEnabled.setAccessible(true);
        Object result = isModuleEnabled.invoke(moduleLoader, targetClass);
        if (!(result instanceof Boolean)) {
            throw new ReflectiveOperationException("Result was not a boolean: maybe another method?");
        }
        return (Boolean)result;
    }

    private boolean isFeatureEnabled(@Nonnull String packageName, @Nonnull String feature) throws ReflectiveOperationException {
        String className = this.toClassName(feature);
        Class<?> targetClass = Class.forName(String.format("vazkii.quark.%s.feature.%s", packageName, className));
        Class<?> featureClass = Class.forName("vazkii.quark.base.module.Feature");
        if (!featureClass.isAssignableFrom(targetClass)) {
            throw new JsonParseException("The given feature '" + feature + "' in module '" + packageName + "' is not a valid Quark feature");
        }
        Class<?> moduleLoader = Class.forName("vazkii.quark.base.module.ModuleLoader");
        Method isFeatureEnabled = moduleLoader.getDeclaredMethod("isFeatureEnabled", Class.class);
        isFeatureEnabled.setAccessible(true);
        Object result = isFeatureEnabled.invoke(moduleLoader, targetClass);
        if (!(result instanceof Boolean)) {
            throw new ReflectiveOperationException("Result was not a boolean: maybe another method?");
        }
        return (Boolean)result;
    }

    @Nonnull
    private String toClassName(@Nonnull String feature) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, feature);
    }
}

