/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.quark.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.common.base.CaseFormat;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StairSlabWallConditionFactory
implements ConditionFactory {
    private static final Map<String, Map<Type, Boolean>> CACHE = new HashMap<String, Map<Type, Boolean>>();

    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String module = JsonUtilities.getString(object, "module");
        if (!module.toLowerCase(Locale.ENGLISH).equals(module)) {
            throw new JsonSyntaxException("Module name '" + module + "' is invalid: must be lowercase");
        }
        String feature = JsonUtilities.getString(object, "feature");
        if (!feature.toLowerCase(Locale.ENGLISH).equals(feature)) {
            throw new JsonSyntaxException("Feature name '" + feature + "' is invalid: must be lowercase");
        }
        String targetType = JsonUtilities.getString(object, "target");
        Type type = Arrays.stream(Type.values()).filter(it -> targetType.equals(it.name().toLowerCase(Locale.ENGLISH))).findFirst().orElseThrow(() -> new JsonSyntaxException("Unrecognized target '" + targetType + "'"));
        String key = module + "@" + feature;
        return new BasicCondition(this.toBoolean(module, feature, type, (Boolean)CACHE.computeIfAbsent(key, it -> this.reflectInto(module, feature)).get((Object)type)));
    }

    @Nonnull
    private Map<Type, Boolean> reflectInto(@Nonnull String module, @Nonnull String feature) {
        try {
            String className = this.toClassName(feature);
            Class<?> targetClass = Class.forName(String.format("vazkii.quark.%s.feature.%s", module, className));
            HashMap<Type, Boolean> map = new HashMap<Type, Boolean>();
            Arrays.stream(Type.values()).forEach(type -> {
                try {
                    Field target = targetClass.getDeclaredField(((Type)type).getFieldName());
                    target.setAccessible(true);
                    map.put((Type)((Object)type), (Boolean)target.get(targetClass));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            });
            return map;
        }
        catch (ReflectiveOperationException e) {
            throw new JsonParseException("Unable to find feature '" + feature + "' in module '" + module + "'");
        }
    }

    @Nonnull
    private String toClassName(@Nonnull String feature) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, feature);
    }

    private boolean toBoolean(@Nonnull String module, @Nonnull String feature, @Nonnull Type type, @Nullable Boolean wrapped) {
        if (wrapped == null) {
            GlobalLoadingState state = Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState());
            state.getReporter().report("No type binding found in feature '" + feature + "' (module '" + module + "') for type '" + (Object)((Object)type) + "': taking a safe approach and returning false", new Object[0]);
            return false;
        }
        return wrapped;
    }

    private static enum Type {
        STAIR("enableStairs"),
        SLAB("enableSlabs"),
        STAIR_SLAB("enableStairsAndSlabs"),
        WALL("enableWalls");

        private final String fieldName;

        private Type(String fieldName) {
            this.fieldName = fieldName;
        }

        @Nonnull
        private String getFieldName() {
            return this.fieldName;
        }
    }
}

