/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.quarkoddities.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class BackpackBehaviorConditionFactory
implements ConditionFactory {
    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String targetBehavior = JsonUtilities.getString(object, "behavior");
        Behavior behavior = Arrays.stream(Behavior.values()).filter(it -> targetBehavior.equals(it.name().toLowerCase(Locale.ENGLISH))).findFirst().orElseThrow(() -> new JsonSyntaxException("Unrecognized behavior '" + targetBehavior + "' for Backpack"));
        boolean targetValue = JsonUtilities.getBooleanOrElse(object, "value", () -> true);
        return new BasicCondition(this.reflectInto(behavior) == targetValue);
    }

    private boolean reflectInto(@Nonnull Behavior behavior) {
        try {
            Class<?> target = Class.forName("vazkii.quark.oddities.feature.Backpacks");
            Field targetField = target.getDeclaredField(behavior.getFieldName());
            targetField.setAccessible(true);
            return (Boolean)targetField.get(null);
        }
        catch (ReflectiveOperationException e) {
            Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter().interrupt("Unable to determine behavior " + (Object)((Object)behavior) + " for backpack! Returning false to be safe!", new Object[0]);
            return false;
        }
    }

    private static enum Behavior {
        TRADE("enableTrades"),
        OP("superOpMode");

        private final String fieldName;

        private Behavior(String fieldName) {
            this.fieldName = fieldName;
        }

        @Nonnull
        private String getFieldName() {
            return this.fieldName;
        }
    }
}

