/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.refinedstorage.consume;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.DocumentationData;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.module.compatibility.refinedstorage.consume.CoverJeiDocumentationConsumer;
import com.aaronhowser1.dymm.module.compatibility.refinedstorage.consume.RecipeRegistryCoverDocumentation;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;

@JEIPlugin
public final class CoverJeiPlugin
implements IModPlugin {
    static final L LOG = L.create("Document Your Mod Mod", "Refined Storage Integration JEI Plugin");

    public void register(@Nonnull IModRegistry registry) {
        LOG.info("Attempting to set up JEI integration for Refined Storage's covers");
        if (!Loader.isModLoaded((String)"refinedstorage")) {
            LOG.warn("Unable to load plugin: Refined Storage isn't loaded");
            return;
        }
        RecipeRegistryCoverDocumentation plugin = new RecipeRegistryCoverDocumentation(registry.getJeiHelpers().getGuiHelper());
        if (plugin.isSuccessful() && !this.shallFallback()) {
            LOG.warn("Experimental behavior is enabled: this will not cause major issues but it may lead to weird errors in the logs.");
            LOG.warn("Do not be scared about stack-traces appearing when viewing documentation: that's normal and it's the reason of why this is marked as 'experimental'");
            registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)plugin);
        } else {
            if (this.shallFallback()) {
                LOG.info("Falling back to non-experimental mode as per request");
            } else {
                LOG.warn("Registration of experimental triggers has failed! Falling back to non-experimental mode!");
            }
            CoverJeiDocumentationConsumer.docData.forEach(it -> registry.addIngredientInfo((Object)((Target)it.getLeft()).obtainTarget(), VanillaTypes.ITEM, ((DocumentationData)it.getRight()).getData().toArray(new String[0])));
        }
        LOG.info("Set up completed");
    }

    private boolean shallFallback() {
        Configuration configuration = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("refinedstorage");
        ConfigCategory category = configuration.getCategory("experimental");
        Property property = category.get("covers_jei_support");
        return !property.getBoolean();
    }
}

