/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression;

import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nullable;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Unit;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KClass;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction0;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction1;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class TryExpression<T>
implements KFunction0<T> {
    private final KFunction0<T> tryBlock;
    private final List<CatchClause<? extends Throwable, T>> catchClauses;
    private final KFunction0<Unit> finallyBlock;

    private TryExpression(@Nonnull KFunction0<T> tryBlock, @Nonnull List<CatchClause<? extends Throwable, T>> catchClauses, @Nonnull KFunction0<Unit> finallyBlock) {
        this.tryBlock = Objects.requireNonNull(tryBlock);
        this.catchClauses = Objects.requireNonNull(catchClauses);
        this.finallyBlock = Objects.requireNonNull(finallyBlock);
    }

    @Nonnull
    public static <T> TryExpression<T> create(@Nonnull KFunction0<T> tryBlock, @Nonnull List<CatchClause<? extends Throwable, T>> catchClauses, @Nonnull KFunction0<Unit> finallyBlock) {
        return new TryExpression<T>(tryBlock, catchClauses, finallyBlock);
    }

    @Nonnull
    public static <T> TryExpression<T> create(@Nonnull KFunction0<T> tryBlock, @Nonnull List<CatchClause<? extends Throwable, T>> catchClauses) {
        return TryExpression.create(tryBlock, catchClauses, () -> Unit.UNIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public T invoke() {
        try {
            T t = this.tryBlock.invoke();
            return t;
        }
        catch (Throwable t) {
            KClass<?> throwableClass = KClass.get(t.getClass());
            Object object = this.catchClauses.stream().filter(it -> ((CatchClause)it).matches(throwableClass)).findFirst().map(it -> ((CatchClause)it).exceptionBlock).orElse(it -> {
                throw t;
            }).invoke((Throwable)this.cast(t));
            return (T)object;
        }
        finally {
            this.finallyBlock.invoke();
        }
    }

    private <K> K cast(@Nonnull Throwable t) {
        return (K)t;
    }

    public static final class CatchClause<E extends Throwable, T>
    implements KFunction1<Throwable, T> {
        private final KClass<E> exceptionClass;
        private final KFunction1<E, T> exceptionBlock;

        private CatchClause(@Nonnull KClass<E> exceptionClass, @Nonnull KFunction1<E, T> exceptionBlock) {
            this.exceptionClass = Objects.requireNonNull(exceptionClass);
            this.exceptionBlock = Objects.requireNonNull(exceptionBlock);
        }

        @Nonnull
        public static <E extends Throwable, T> CatchClause<E, T> create(@Nonnull KClass<E> exceptionClass, @Nonnull KFunction1<E, T> exceptionBlock) {
            return new CatchClause<E, T>(exceptionClass, exceptionBlock);
        }

        private boolean matches(@Nonnull KClass<?> otherExceptionClass) {
            return this.exceptionClass.isSuperClassOf(otherExceptionClass);
        }

        @Override
        @Nonnull
        public T invoke(@Nonnull Throwable e) {
            return this.exceptionBlock.invoke(this.exceptionClass.cast(Nullable.get(e)));
        }
    }
}

